/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

import com.wavemaker.common.util.ObjectUtils;

public class OrderBy {
    private static final String ERROR_MSG = "orderBy format must be: asc|desc:<propertyPath>";
    private static final String ORDER_BY_SEP = ":";
    private String propertyPath = null;
    private SortOrder sortOrder = null;

    public static OrderBy newInstance(String orderBy) {
        if (ObjectUtils.isNullOrEmpty((String)orderBy)) {
            throw new IllegalArgumentException("orderBy cannot be null or empty");
        }
        int i = (orderBy = orderBy.trim()).indexOf(ORDER_BY_SEP);
        if (i == -1 || i == 0 || i == orderBy.length() - 1) {
            throw new IllegalArgumentException(ERROR_MSG);
        }
        OrderBy rtn = new OrderBy();
        String propertyPath = orderBy.substring(i + 1).trim();
        String order = orderBy.substring(0, i).trim();
        if (order.equalsIgnoreCase("asc")) {
            rtn.setAsc(propertyPath);
        } else if (order.equals("desc")) {
            rtn.setDesc(propertyPath);
        } else {
            throw new IllegalArgumentException("\"" + orderBy + "\" " + ERROR_MSG);
        }
        return rtn;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public void setAsc(String propertyPath) {
        this.sortOrder = SortOrder.ASC;
        this.propertyPath = propertyPath;
    }

    public void setDesc(String propertyPath) {
        this.sortOrder = SortOrder.DESC;
        this.propertyPath = propertyPath;
    }

    public boolean isAsc() {
        return this.sortOrder == SortOrder.ASC;
    }

    public boolean isDesc() {
        return this.sortOrder == SortOrder.DESC;
    }

    public String toString() {
        StringBuilder rtn = new StringBuilder();
        if (this.sortOrder != null) {
            rtn.append(this.sortOrder.toString());
        }
        rtn.append(this.propertyPath);
        return rtn.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder {
        ASC,
        DESC;


        public String toString() {
            if (this == ASC) {
                return "asc:";
            }
            return "desc:";
        }
    }
}

