/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

import com.wavemaker.common.NotYetImplementedException;
import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.server.DownloadResponse;
import com.wavemaker.runtime.server.InternalRuntime;
import com.wavemaker.runtime.server.JSONParameterTypeField;
import com.wavemaker.runtime.server.ServerUtils;
import com.wavemaker.runtime.service.PagingOptions;
import com.wavemaker.runtime.service.ParsedServiceArguments;
import com.wavemaker.runtime.service.PropertyOptions;
import com.wavemaker.runtime.service.ServiceManager;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypeManager;
import com.wavemaker.runtime.service.TypeNotFoundException;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.runtime.service.events.ServiceEventNotifier;
import com.wavemaker.runtime.service.response.SuccessResponse;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class RuntimeService {
    private TypeManager typeManager;
    private ServiceManager serviceManager;
    private ServiceEventNotifier serviceEventNotifier;
    private InternalRuntime internalRuntime;
    private RuntimeAccess runtimeAccess;

    public Object getProperty(@JSONParameterTypeField(typeParameter=1) Object instance, String type, String propertyName) throws Exception {
        ServiceWire serviceWire = this.typeManager.getServiceWireForType(type);
        if (serviceWire.isLiveDataService()) {
            PropertyOptions po = new PropertyOptions();
            po.getProperties().add(propertyName);
            TypedServiceReturn resp = this.read(this.typeManager.getServiceIdForType(type), type, instance, po, null);
            Object o = ((SuccessResponse)resp.getReturnValue()).getResult();
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                o = c.isEmpty() ? null : c.iterator().next();
            }
            if (o == null) {
                return null;
            }
            Object ret = PropertyUtils.getProperty(o, propertyName);
            return ret;
        }
        throw new NotYetImplementedException();
    }

    public TypedServiceReturn read(String serviceName, String typeName, @JSONParameterTypeField(typeParameter=1) Object instance, PropertyOptions propertyOptions, PagingOptions pagingOptions) throws Exception {
        ServiceWire sw = this.getServiceWire(serviceName, typeName);
        sw.getServiceType().setup(sw, this.internalRuntime, this.runtimeAccess);
        TypeDefinition typeDefinition = this.internalRuntime.getJSONState().getTypeState().getType(typeName);
        String methodName = "read";
        JSONState jc = this.getInternalRuntime().getJSONState();
        jc.setTrimStackLevel(1);
        if (null != this.getInternalRuntime() && null != jc && null != jc.getRequiredProperties() && null != propertyOptions && null != propertyOptions.getProperties()) {
            List jcProperties = jc.getRequiredProperties();
            for (String property : propertyOptions.getProperties()) {
                jcProperties.add(property);
            }
        }
        if (sw.isLiveDataService()) {
            ParsedServiceArguments psa = new ParsedServiceArguments();
            psa.setArguments(new Object[]{typeDefinition, instance, propertyOptions, pagingOptions});
            TypedServiceReturn ret = ServerUtils.invokeMethodWithEvents(this.getServiceEventNotifier(), sw, methodName, psa, jc, true);
            return ret;
        }
        throw new NotYetImplementedException();
    }

    public TypedServiceReturn update(String serviceName, String typeName, @JSONParameterTypeField(typeParameter=1) Object objectToUpdate) throws Exception {
        ServiceWire sw = this.getServiceWire(serviceName, typeName);
        sw.getServiceType().setup(sw, this.internalRuntime, this.runtimeAccess);
        String methodName = "update";
        if (sw.isLiveDataService()) {
            this.shiftDeserializedProperties(2);
            ParsedServiceArguments psa = new ParsedServiceArguments();
            psa.setArguments(new Object[]{objectToUpdate});
            return ServerUtils.invokeMethodWithEvents(this.getServiceEventNotifier(), sw, methodName, psa, this.getInternalRuntime().getJSONState(), true);
        }
        throw new NotYetImplementedException();
    }

    public TypedServiceReturn insert(String serviceName, String typeName, @JSONParameterTypeField(typeParameter=1) Object objectToInsert) throws Exception {
        ServiceWire sw = this.getServiceWire(serviceName, typeName);
        sw.getServiceType().setup(sw, this.internalRuntime, this.runtimeAccess);
        String methodName = "insert";
        if (sw.isLiveDataService()) {
            ParsedServiceArguments psa = new ParsedServiceArguments();
            psa.setArguments(new Object[]{objectToInsert});
            return ServerUtils.invokeMethodWithEvents(this.getServiceEventNotifier(), sw, methodName, psa, this.getInternalRuntime().getJSONState(), true);
        }
        throw new NotYetImplementedException();
    }

    public void delete(String serviceName, String typeName, @JSONParameterTypeField(typeParameter=1) Object objectToDelete) throws Exception {
        ServiceWire sw = this.getServiceWire(serviceName, typeName);
        sw.getServiceType().setup(sw, this.internalRuntime, this.runtimeAccess);
        String methodName = "delete";
        if (!sw.isLiveDataService()) {
            throw new NotYetImplementedException();
        }
        ParsedServiceArguments psa = new ParsedServiceArguments();
        psa.setArguments(new Object[]{objectToDelete});
        ServerUtils.invokeMethodWithEvents(this.getServiceEventNotifier(), sw, methodName, psa, this.getInternalRuntime().getJSONState(), true);
    }

    public String getLocalHostIP() {
        return SystemUtils.getIP();
    }

    public String getSessionId() {
        return RuntimeAccess.getInstance().getSession().getId();
    }

    public DownloadResponse echo(String contents, String contentType, String fileName) {
        ByteArrayInputStream is;
        try {
            is = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        return new DownloadResponse(is, contentType, fileName);
    }

    private void shiftDeserializedProperties(int index) {
        InternalRuntime ir = InternalRuntime.getInstance();
        List<List<String>> org = ir.getDeserializedProperties();
        int size = org.size() - index;
        ArrayList<List<String>> props = new ArrayList<List<String>>(size);
        for (int i = index; i < org.size(); ++i) {
            props.add(org.get(i));
        }
        ir.setDeserializedProperties(props);
    }

    public ServiceWire getServiceWire(String serviceName, String typeName) {
        ServiceWire serviceWire = null;
        Object enclosedException = null;
        if (null != serviceName && 0 != serviceName.length()) {
            serviceWire = this.serviceManager.getServiceWire(serviceName);
        } else {
            try {
                String serviceId = this.typeManager.getServiceIdForType(typeName);
                serviceWire = this.serviceManager.getServiceWire(serviceId);
            }
            catch (TypeNotFoundException e) {
                enclosedException = e;
            }
            catch (WMRuntimeException e2) {
                enclosedException = e2;
            }
        }
        if (null == serviceWire && null == enclosedException) {
            throw new WMRuntimeException(Resource.NO_SERVICE_FROM_ID_TYPE, new Object[]{serviceName, typeName});
        }
        if (null == serviceWire) {
            throw new WMRuntimeException(Resource.NO_SERVICE_FROM_ID_TYPE, (Throwable)enclosedException, new Object[]{serviceName, typeName});
        }
        return serviceWire;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ServiceEventNotifier getServiceEventNotifier() {
        return this.serviceEventNotifier;
    }

    public void setServiceEventNotifier(ServiceEventNotifier serviceEventNotifier) {
        this.serviceEventNotifier = serviceEventNotifier;
    }

    public InternalRuntime getInternalRuntime() {
        return this.internalRuntime;
    }

    public void setInternalRuntime(InternalRuntime internalRuntime) {
        this.internalRuntime = internalRuntime;
    }

    public RuntimeAccess getRuntimeAccess() {
        return this.runtimeAccess;
    }

    public void setRuntimeAccess(RuntimeAccess runtimeAccess) {
        this.runtimeAccess = runtimeAccess;
    }
}

