/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.SpringUtils;
import com.wavemaker.runtime.service.ServiceType;
import com.wavemaker.runtime.service.ServiceWire;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManager
implements ApplicationContextAware {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private ApplicationContext applicationContext = null;
    private Set<ServiceType> serviceTypes = new HashSet<ServiceType>();
    private Set<ServiceWire> serviceWires = new HashSet<ServiceWire>();

    public Object getService(String serviceId) {
        if (this.serviceWires == null) {
            SpringUtils.throwSpringNotInitializedError(this.getClass());
        }
        if (!this.getServices().contains(serviceId)) {
            throw new WMRuntimeException(Resource.UNKNOWN_SERVICE, new Object[]{serviceId});
        }
        return this.applicationContext.getBean(serviceId);
    }

    public Object getService(Class<?> serviceType) {
        Map m;
        if (this.serviceWires == null) {
            SpringUtils.throwSpringNotInitializedError(this.getClass());
        }
        if ((m = CastUtils.cast((Map)this.applicationContext.getBeansOfType(serviceType))).isEmpty()) {
            throw new WMRuntimeException(Resource.UNKNOWN_SERVICE_TYPE, new Object[]{serviceType.getName()});
        }
        HashMap foundServices = new HashMap();
        for (Map.Entry entry : m.entrySet()) {
            if (!this.getServices().contains(entry.getKey())) continue;
            foundServices.put(entry.getKey(), entry.getValue());
        }
        if (foundServices.isEmpty() || 0 == foundServices.size()) {
            throw new WMRuntimeException(Resource.UNKNOWN_SERVICE_TYPE, new Object[]{serviceType.getName()});
        }
        if (foundServices.size() > 1) {
            throw new WMRuntimeException(Resource.MULTIPLE_SERVICE_BEANS, new Object[]{serviceType.getName()});
        }
        Map.Entry entry = foundServices.entrySet().iterator().next();
        return entry.getValue();
    }

    public ServiceWire getServiceWire(String serviceId) {
        if (this.serviceWires == null) {
            SpringUtils.throwSpringNotInitializedError(this.getClass());
        }
        ServiceWire ret = null;
        for (ServiceWire sw : this.serviceWires) {
            if (!sw.getServiceId().equals(serviceId)) continue;
            if (null == ret) {
                ret = sw;
                continue;
            }
            throw new WMRuntimeException(Resource.SERVICEWIRE_ID_DUP, new Object[]{serviceId});
        }
        return ret;
    }

    public Set<String> getServices() {
        if (this.serviceWires == null) {
            SpringUtils.throwSpringNotInitializedError(this.getClass());
        }
        HashSet<String> ret = new HashSet<String>();
        for (ServiceWire wire : this.serviceWires) {
            ret.add(wire.getServiceId());
        }
        return ret;
    }

    public void addServiceType(ServiceType serviceType) {
        for (ServiceType st : this.serviceTypes) {
            if (!st.getTypeName().equals(serviceType.getTypeName())) continue;
            this.logger.warn((Object)("redefining ServiceType " + serviceType.getTypeName()));
            return;
        }
        this.logger.info((Object)("Adding ServiceType " + serviceType.getTypeName()));
        this.serviceTypes.add(serviceType);
    }

    public void addServiceWire(ServiceWire serviceWire) {
        if (null == this.getServiceWire(serviceWire.getServiceId())) {
            this.logger.info((Object)("Adding ServiceWire " + serviceWire));
            this.serviceWires.add(serviceWire);
        } else {
            this.logger.warn((Object)("Attempt to re-add ServiceWire " + serviceWire));
            this.serviceWires.add(serviceWire);
        }
    }

    public Set<ServiceType> getServiceTypes() {
        return this.serviceTypes;
    }

    protected Set<ServiceWire> getServiceWires() {
        return this.serviceWires;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

