/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

import com.wavemaker.runtime.service.ServiceManager;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypeNotFoundException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager {
    private Map<String, List<String>> types;
    private ServiceManager serviceManager;

    public List<String> getTypes(String serviceId) {
        return this.getTypes().get(serviceId);
    }

    public String getServiceIdForType(String type) throws TypeNotFoundException {
        String foundServiceId = null;
        block0: for (Map.Entry<String, List<String>> entry : this.types.entrySet()) {
            for (String serviceType : entry.getValue()) {
                if (!serviceType.equals(type)) continue;
                foundServiceId = entry.getKey();
                break block0;
            }
        }
        return foundServiceId;
    }

    public Object getServiceForType(String type) throws TypeNotFoundException {
        String serviceId = this.getServiceIdForType(type);
        return this.getServiceManager().getService(serviceId);
    }

    public ServiceWire getServiceWireForType(String type) throws TypeNotFoundException {
        String serviceId = this.getServiceIdForType(type);
        return this.getServiceManager().getServiceWire(serviceId);
    }

    public Map<String, List<String>> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, List<String>> types) {
        this.types = types;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }
}

