/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.server.DownloadResponse;
import com.wavemaker.runtime.server.InternalRuntime;
import com.wavemaker.runtime.service.ServiceManager;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypeManager;
import com.wavemaker.runtime.service.TypeNotFoundException;
import com.wavemaker.runtime.service.events.ServiceEventNotifier;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public class WaveMakerService {
    private TypeManager typeManager;
    private ServiceManager serviceManager;
    private ServiceEventNotifier serviceEventNotifier;
    private InternalRuntime internalRuntime;
    private RuntimeAccess runtimeAccess;

    public String getLocalHostIP() {
        return SystemUtils.getIP();
    }

    public String getSessionId() {
        return RuntimeAccess.getInstance().getSession().getId();
    }

    public DownloadResponse echo(String contents, String contentType, String fileName) {
        ByteArrayInputStream is;
        try {
            is = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        return new DownloadResponse(is, contentType, fileName);
    }

    public ServiceWire getServiceWire(String serviceName, String typeName) {
        ServiceWire serviceWire = null;
        Object enclosedException = null;
        if (null != serviceName && 0 != serviceName.length()) {
            serviceWire = this.serviceManager.getServiceWire(serviceName);
        } else {
            try {
                String serviceId = this.typeManager.getServiceIdForType(typeName);
                serviceWire = this.serviceManager.getServiceWire(serviceId);
            }
            catch (TypeNotFoundException e) {
                enclosedException = e;
            }
            catch (WMRuntimeException e2) {
                enclosedException = e2;
            }
        }
        if (null == serviceWire && null == enclosedException) {
            throw new WMRuntimeException(Resource.NO_SERVICE_FROM_ID_TYPE, new Object[]{serviceName, typeName});
        }
        if (null == serviceWire) {
            throw new WMRuntimeException(Resource.NO_SERVICE_FROM_ID_TYPE, (Throwable)enclosedException, new Object[]{serviceName, typeName});
        }
        return serviceWire;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ServiceEventNotifier getServiceEventNotifier() {
        return this.serviceEventNotifier;
    }

    public void setServiceEventNotifier(ServiceEventNotifier serviceEventNotifier) {
        this.serviceEventNotifier = serviceEventNotifier;
    }

    public InternalRuntime getInternalRuntime() {
        return this.internalRuntime;
    }

    public void setInternalRuntime(InternalRuntime internalRuntime) {
        this.internalRuntime = internalRuntime;
    }

    public RuntimeAccess getRuntimeAccess() {
        return this.runtimeAccess;
    }

    public void setRuntimeAccess(RuntimeAccess runtimeAccess) {
        this.runtimeAccess = runtimeAccess;
    }
}

