/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service.events;

import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.events.EventWire;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private List<EventWire> eventWires = new ArrayList<EventWire>();

    public <T> Map<T, List<ServiceWire>> getEventListeners(Class<?> T) {
        HashMap ret = new HashMap();
        if (null != this.eventWires && !this.eventWires.isEmpty()) {
            for (EventWire wire : this.eventWires) {
                if (!T.isAssignableFrom(wire.getEventListener().getClass())) continue;
                if (!ret.containsKey(wire.getEventListener())) {
                    ret.put(wire.getEventListener(), new ArrayList());
                }
                ((List)ret.get(wire.getEventListener())).add(wire.getServiceWire());
            }
        }
        return ret;
    }

    public void addEvent(Object eventListener, ServiceWire serviceWire) {
        EventWire wire = new EventWire();
        wire.setServiceWire(serviceWire);
        wire.setEventListener(eventListener);
        this.eventWires.add(wire);
    }

    public void addEventWire(EventWire eventWire) {
        this.logger.info((Object)("Adding EventWire " + eventWire));
        this.getEventWires().add(eventWire);
    }

    protected List<EventWire> getEventWires() {
        return this.eventWires;
    }
}

