/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.ws;

import com.wavemaker.runtime.ws.BindingProperties;
import com.wavemaker.runtime.ws.HTTPBindingSupport;
import com.wavemaker.runtime.ws.WebServiceException;
import com.wavemaker.runtime.ws.WebServiceInvocationException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTService {
    protected String serviceId;
    protected QName serviceQName;
    protected String parameterizedURI;
    protected BindingProperties bindingProperties;
    protected HTTPBindingSupport.HTTPRequestMethod httpRequestMethod;

    public RESTService(String serviceId, QName serviceQName, String parameterizedURI) {
        this(serviceId, serviceQName, parameterizedURI, null);
    }

    public RESTService(String serviceId, QName serviceQName, String parameterizedURI, BindingProperties bindingProperties) {
        this.serviceId = serviceId;
        this.serviceQName = serviceQName;
        this.parameterizedURI = parameterizedURI;
        this.bindingProperties = bindingProperties;
    }

    public <T> T invoke(Map<String, Object> inputs, Class<T> responseType) {
        return this.invoke(inputs, null, null, null, responseType);
    }

    public <T> T invoke(Map<String, Object> inputs, String method, String contentType, String endpoint, Class<T> responseType) {
        return this.invoke(inputs, method, contentType, endpoint, responseType, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T invoke(Map<String, Object> inputs, String method, String contentType, String endpoint, Class<T> responseType, String partnerName) {
        String endpointAddress = null;
        endpointAddress = endpoint != null ? endpoint : this.parameterizedURI;
        Object postData = "";
        if (method != null && method.equals("POST")) {
            this.httpRequestMethod = HTTPBindingSupport.HTTPRequestMethod.POST;
            if (inputs.size() == 1) {
                Iterator<Object> i$ = inputs.values().iterator();
                while (i$.hasNext()) {
                    Object o;
                    postData = o = i$.next();
                }
            } else if (inputs.size() > 1) {
                if (!contentType.equalsIgnoreCase("application/x-www-form-urlencoded")) throw new WebServiceInvocationException("REST service call with HTTP POST should not have more than 1 input.");
                postData = this.createFormData(inputs);
            }
        } else {
            this.httpRequestMethod = HTTPBindingSupport.HTTPRequestMethod.GET;
            endpointAddress = RESTService.parameterize(endpointAddress, inputs);
        }
        try {
            return HTTPBindingSupport.getResponseObject(this.serviceQName, this.serviceQName, endpointAddress, this.httpRequestMethod, contentType, postData, responseType, this.bindingProperties, partnerName);
        }
        catch (WebServiceException e) {
            throw new WebServiceInvocationException((Throwable)((Object)e));
        }
    }

    private String createFormData(Map<String, Object> inputs) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, Object>> entries = inputs.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            sb.append(entry.getKey());
            sb.append("=");
            if (entry.getValue() != null) {
                sb.append((String)entry.getValue());
            }
            sb.append("&");
        }
        return sb.toString();
    }

    private static String parameterize(String parameterizedURI, Map<String, Object> inputs) {
        StringBuilder endpointAddress = new StringBuilder(parameterizedURI);
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            String param = entry.getKey();
            int index = endpointAddress.indexOf("{" + param + "}");
            if (index <= -1) continue;
            try {
                String v = entry.getValue() != null ? entry.getValue().toString() : "";
                v = URLEncoder.encode(v, "UTF-8");
                v = v.replaceAll("\\+", "%20");
                endpointAddress.replace(index, index + param.length() + 2, v);
            }
            catch (UnsupportedEncodingException e) {
                throw new WebServiceInvocationException(e);
            }
        }
        return endpointAddress.toString();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setHttpRequestMethod(String method) {
        this.httpRequestMethod = HTTPBindingSupport.HTTPRequestMethod.valueOf(method);
    }

    public BindingProperties getBindingProperties() {
        return this.bindingProperties;
    }

    public void setBindingProperties(BindingProperties bindingProperties) {
        this.bindingProperties = bindingProperties;
    }
}

