/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.ws;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import com.wavemaker.runtime.service.annotations.ExposeToClient;
import com.wavemaker.runtime.service.annotations.HideFromClient;
import com.wavemaker.runtime.ws.BindingProperties;
import com.wavemaker.runtime.ws.Feed;
import com.wavemaker.runtime.ws.WebServiceInvocationException;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import sun.misc.BASE64Encoder;

@HideFromClient
public class SyndFeedService {
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final String USER_AGENT_VALUE = "WaveMaker http://dev.wavemaker.com";
    private static final String BASIC_AUTH_KEY = "Authorization";
    private static final String BASIC_AUTH_VALUE_PREFIX = "Basic ";
    private BindingProperties bindingProperties;

    @ExposeToClient
    public Feed getFeed(String feedURL) {
        String httpBasicAuthUsername = null;
        String httpBasicAuthPassword = null;
        int connectionTimeout = 0;
        if (this.bindingProperties != null) {
            connectionTimeout = this.bindingProperties.getConnectionTimeout();
            httpBasicAuthUsername = this.bindingProperties.getHttpBasicAuthUsername();
            if (httpBasicAuthUsername != null) {
                httpBasicAuthPassword = this.bindingProperties.getHttpBasicAuthPassword();
            }
        }
        return this.getFeedWithHttpConfig(feedURL, httpBasicAuthUsername, httpBasicAuthPassword, connectionTimeout);
    }

    @ExposeToClient
    public Feed getFeedWithHttpConfig(String feedURL, String httpBasicAuthUsername, String httpBasicAuthPassword, int connectionTimeout) {
        URL url = null;
        try {
            url = new URL(feedURL);
        }
        catch (MalformedURLException e) {
            throw new WebServiceInvocationException(e);
        }
        SyndFeedInput input = new SyndFeedInput();
        try {
            URLConnection urlConn = url.openConnection();
            if (urlConn instanceof HttpURLConnection) {
                urlConn.setAllowUserInteraction(false);
                urlConn.setDoInput(true);
                urlConn.setDoOutput(false);
                ((HttpURLConnection)urlConn).setInstanceFollowRedirects(true);
                urlConn.setUseCaches(false);
                urlConn.setRequestProperty(USER_AGENT_KEY, USER_AGENT_VALUE);
                urlConn.setConnectTimeout(connectionTimeout);
                if (httpBasicAuthUsername != null && httpBasicAuthUsername.length() > 0) {
                    String auth = httpBasicAuthPassword == null ? httpBasicAuthUsername : httpBasicAuthUsername + ":" + httpBasicAuthPassword;
                    urlConn.setRequestProperty(BASIC_AUTH_KEY, BASIC_AUTH_VALUE_PREFIX + new BASE64Encoder().encode(auth.getBytes()));
                }
            }
            SyndFeed feed = input.build((Reader)new XmlReader(urlConn));
            return new Feed(feed);
        }
        catch (IllegalArgumentException e) {
            throw new WebServiceInvocationException(e);
        }
        catch (FeedException e) {
            throw new WebServiceInvocationException(e);
        }
        catch (IOException e) {
            throw new WebServiceInvocationException(e);
        }
    }

    public BindingProperties getBindingProperties() {
        return this.bindingProperties;
    }

    public void setBindingProperties(BindingProperties bindingProperties) {
        this.bindingProperties = bindingProperties;
    }
}

