/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.ws.infoteria;

import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.runtime.ws.HTTPBindingSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.json.JSONObject;

public class AutoLoginService {
    private String sessionId = null;

    public String logIn(String project) throws Exception {
        String postData;
        if (this.sessionId != null) {
            return this.sessionId;
        }
        String fname = project + ".properties";
        File propF = ClassLoaderUtils.getClasspathFile((String)fname);
        FileInputStream is = new FileInputStream(propF);
        Properties props = SystemUtils.loadPropertiesFromStream((InputStream)is);
        String host = props.getProperty(project + ".host");
        String port = props.getProperty(project + ".port");
        String domain = props.getProperty(project + ".domain");
        String userName = props.getProperty(project + ".username");
        String password = props.getProperty(project + ".password");
        password = SystemUtils.decrypt((String)password);
        String endPointAddress = "http://" + host + ":" + port + "/flow-rest/auth/login.json";
        QName thisQName = new QName(endPointAddress, "asteriaServer");
        String result = HTTPBindingSupport.getResponseObject(thisQName, thisQName, endPointAddress, HTTPBindingSupport.HTTPRequestMethod.POST, "application/x-www-form-urlencoded", postData = "user=" + domain + userName + "&password=" + password, String.class, null);
        JSONObject returnObj = new JSONObject(result);
        JSONObject sessionObj = (JSONObject)returnObj.get("result");
        String status = (String)sessionObj.get("status");
        if (!status.equals("true")) {
            throw new Exception("Login falied");
        }
        String sessid = (String)sessionObj.get("id");
        this.sessionId = sessid;
        return sessid;
    }

    public String logOut(String host, String port, String sessId) throws Exception {
        String postData;
        if (sessId == null) {
            throw new Exception("Null session id is passed.");
        }
        String endPointAddress = "http://" + host + ":" + port + "/flow-rest/auth/logout.json";
        QName thisQName = new QName(endPointAddress, "asteriaServer");
        String result = HTTPBindingSupport.getResponseObject(thisQName, thisQName, endPointAddress, HTTPBindingSupport.HTTPRequestMethod.POST, "application/x-www-form-urlencoded", postData = "sessionid=" + sessId, String.class, null);
        JSONObject returnObj = new JSONObject(result);
        JSONObject sessionObj = (JSONObject)returnObj.get("result");
        String status = (String)sessionObj.get("status");
        if (!status.equals("true")) {
            throw new Exception("Logout falied.");
        }
        String oldSessionId = (String)sessionObj.get("id");
        this.sessionId = null;
        return oldSessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

