/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.ws.jaxws;

import com.sun.xml.ws.developer.WSBindingProvider;
import com.wavemaker.runtime.ws.BindingProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class SOAPBindingResolver {
    public static void setBindingProperties(BindingProvider service, BindingProperties bindingProperties) {
        if (bindingProperties != null) {
            Map<String, List<String>> httpHeaders;
            String httpBasicAuthUsername;
            Map requestContext = service.getRequestContext();
            String endpointAddress = bindingProperties.getEndpointAddress();
            if (endpointAddress != null) {
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointAddress);
            }
            if ((httpBasicAuthUsername = bindingProperties.getHttpBasicAuthUsername()) != null) {
                requestContext.put("javax.xml.ws.security.auth.username", httpBasicAuthUsername);
                String httpBasicAuthPassword = bindingProperties.getHttpBasicAuthPassword();
                requestContext.put("javax.xml.ws.security.auth.password", httpBasicAuthPassword);
            }
            int connectionTimeout = bindingProperties.getConnectionTimeout();
            requestContext.put("com.sun.xml.ws.connect.timeout", connectionTimeout);
            int requestTimeout = bindingProperties.getRequestTimeout();
            requestContext.put("com.sun.xml.ws.request.timeout", requestTimeout);
            String soapActionURI = bindingProperties.getSoapActionURI();
            if (soapActionURI != null) {
                requestContext.put("javax.xml.ws.soap.http.soapaction.use", true);
                requestContext.put("javax.xml.ws.soap.http.soapaction.uri", soapActionURI);
            }
            if ((httpHeaders = bindingProperties.getHttpHeaders()) != null && !httpHeaders.isEmpty()) {
                HashMap<String, List<String>> reqHeaders = (HashMap<String, List<String>>)requestContext.get("javax.xml.ws.http.request.headers");
                if (reqHeaders == null) {
                    reqHeaders = new HashMap<String, List<String>>();
                    requestContext.put("javax.xml.ws.http.request.headers", reqHeaders);
                }
                for (Map.Entry<String, List<String>> entry : httpHeaders.entrySet()) {
                    reqHeaders.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Deprecated
    public static void resolve(BindingProvider service, BindingProperties bindingProperties) {
        SOAPBindingResolver.setBindingProperties(service, bindingProperties);
    }

    public static void setHeaders(WSBindingProvider service, Object ... headers) {
        ArrayList<Object> soapHeaders = new ArrayList<Object>();
        for (Object header : headers) {
            if (header == null) continue;
            soapHeaders.add(header);
        }
        if (!soapHeaders.isEmpty()) {
            service.setOutboundHeaders(soapHeaders.toArray(new Object[soapHeaders.size()]));
        }
    }
}

