/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.ws.salesforce;

import com.wavemaker.runtime.ws.BindingProperties;
import com.wavemaker.runtime.ws.salesforce.gen.Login;
import com.wavemaker.runtime.ws.salesforce.gen.LoginResponse;
import com.wavemaker.runtime.ws.salesforce.gen.LoginScopeHeader;
import com.wavemaker.runtime.ws.salesforce.gen.Logout;
import com.wavemaker.runtime.ws.salesforce.gen.LogoutResponse;
import com.wavemaker.runtime.ws.salesforce.gen.SessionHeader;
import com.wavemaker.runtime.ws.salesforce.gen.SforceService;

public class LoginObject {
    private SforceService service;
    private SessionHeader sessionHeader = null;

    public String logIn(String userName, String password) throws Exception {
        if (this.sessionHeader != null) {
            return "You are already logged in";
        }
        Login parameters = new Login();
        parameters.setUsername(userName);
        parameters.setPassword(password);
        LoginResponse response = this.service.login(parameters, new LoginScopeHeader(), null);
        BindingProperties bindingProperties = new BindingProperties();
        bindingProperties.setEndpointAddress(response.getResult().getServerUrl());
        this.service.setBindingProperties(bindingProperties);
        String sessionId = response.getResult().getSessionId();
        this.sessionHeader = new SessionHeader();
        this.sessionHeader.setSessionId(sessionId);
        return "Logged in successfully";
    }

    public String logOut() throws Exception {
        Logout parameters = new Logout();
        if (this.sessionHeader == null) {
            return "You are not logged in yet";
        }
        LogoutResponse response = this.service.logout(parameters, this.sessionHeader, null);
        this.sessionHeader = null;
        return "Logged out";
    }

    public SessionHeader getSessionHeader() throws Exception {
        if (this.sessionHeader == null) {
            throw new Exception("You must log in first");
        }
        return this.sessionHeader;
    }

    public SforceService getSforceService() throws Exception {
        if (this.service == null) {
            throw new Exception("You must log in first");
        }
        return this.service;
    }

    public void setSforceService(SforceService svc) {
        this.service = svc;
    }
}

