/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.ws.salesforce;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.common.util.TypeConversionUtils;
import com.wavemaker.json.JSONArray;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.WMAppContext;
import com.wavemaker.runtime.data.util.QueryHandler;
import com.wavemaker.runtime.service.PagingOptions;
import com.wavemaker.runtime.ws.salesforce.LoginService;
import com.wavemaker.runtime.ws.salesforce.gen.DescribeGlobal;
import com.wavemaker.runtime.ws.salesforce.gen.DescribeGlobalResponse;
import com.wavemaker.runtime.ws.salesforce.gen.DescribeGlobalSObjectResultType;
import com.wavemaker.runtime.ws.salesforce.gen.DescribeSObject;
import com.wavemaker.runtime.ws.salesforce.gen.DescribeSObjectResponse;
import com.wavemaker.runtime.ws.salesforce.gen.FieldType;
import com.wavemaker.runtime.ws.salesforce.gen.PicklistEntryType;
import com.wavemaker.runtime.ws.salesforce.gen.QueryResultType;
import com.wavemaker.runtime.ws.salesforce.gen.SObjectType;
import com.wavemaker.runtime.ws.salesforce.gen.SessionHeader;
import com.wavemaker.runtime.ws.salesforce.gen.SforceService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesforceSupport {
    private static final String[] SYS_MAINT_FIELDS = new String[]{"CreatedBy", "CreatedById", "CreatedDate", "LastModifiedBy", "LastModifiedById", "LastModifiedDate", "SystemModstamp", "IsDeleted", "FieldsToNulls"};
    private static final String[] OPTIONAL_FIELDS = new String[]{"ActivityHistories", "Attachments", "Events", "FeedSubscriptionsForEntity", "Histories", "LastActivityDate", "Notes", "NotesAndAttachments", "OpenActivities", "Owner", "OwnerId", "ProcessInstances", "ProcessSteps", "Tasks"};
    private Map<String, List<FieldType>> fieldsMap = null;
    private LoginService loginSvcBean = (LoginService)RuntimeAccess.getInstance().getSpringBean("sfLoginService");
    private int lastQryId = 0;
    private Map<Integer, SingleQuery> queryMap = new TreeMap<Integer, SingleQuery>();
    private MultiValueMap parentQueryMap = new MultiValueMap();
    private MultiValueMap resultRows;
    private Map<List<Object>, com.wavemaker.json.JSONObject> resultJsonObjs;
    Long recId;

    public com.wavemaker.json.JSONObject getPickLists(String objClassName, com.wavemaker.json.JSONObject fieldAndValuePairs) throws Exception {
        com.wavemaker.json.JSONObject carrier = new com.wavemaker.json.JSONObject();
        String objName = SalesforceSupport.getSalesforceObjName(objClassName);
        Set entries = fieldAndValuePairs.entrySet();
        for (Map.Entry e : entries) {
            FieldType field;
            String fieldName = (String)e.getKey();
            if (carrier.containsKey((Object)fieldName) || (field = this.getField(objName, fieldName)).getType().value().equals("boolean")) continue;
            com.wavemaker.json.JSONObject result = this.getPickList(objName, field, fieldAndValuePairs, carrier);
            carrier.put((Object)fieldName, (Object)result);
        }
        return carrier;
    }

    public com.wavemaker.json.JSONObject getPickList(String objName, FieldType currentField, com.wavemaker.json.JSONObject fieldAndValuePairs, com.wavemaker.json.JSONObject carrier) throws Exception {
        List<FieldType> fields = this.getFields(objName);
        HashMap<String, FieldType> fieldMap = new HashMap<String, FieldType>();
        for (FieldType fld : fields) {
            fieldMap.put(fld.getName(), fld);
        }
        List<FieldType> controlPath = this.getControlPath(currentField, fieldMap, null);
        if (controlPath == null) {
            List<PicklistEntryType> picklistValues = currentField.getPicklistValues();
            if (picklistValues != null && picklistValues.size() > 0) {
                return this.prepareJSONObject(picklistValues, fieldAndValuePairs, currentField);
            }
            return null;
        }
        Collections.reverse(controlPath);
        if (carrier == null) {
            carrier = new com.wavemaker.json.JSONObject();
        }
        com.wavemaker.json.JSONObject plist = null;
        for (int i = 0; i < controlPath.size(); ++i) {
            FieldType fld = controlPath.get(i);
            if (fld.getType().value().equals("boolean") || carrier.containsKey((Object)this.downShiftFirstChar(fld.getName()))) continue;
            FieldType controller = i == 0 ? null : controlPath.get(i - 1);
            plist = this.getRestrictedPickList(objName, fld, controller, fieldAndValuePairs);
            if (i >= controlPath.size() - 1) continue;
            carrier.put((Object)this.downShiftFirstChar(currentField.getName()), (Object)plist);
        }
        return plist;
    }

    private void setupFields(String objName) throws Exception {
        DescribeSObject parameters = new DescribeSObject();
        parameters.setSObjectType(SalesforceSupport.getSalesforceObjName(objName));
        String result = this.loginSvcBean.logIn("sammysm@wavemaker.com", "Silver77Surfer");
        SessionHeader sessionHeader = LoginService.getSessionHeader();
        SforceService service = LoginService.getSforceService();
        DescribeSObjectResponse dresponse = service.describeSObject(parameters, sessionHeader, null, null, null);
        List<FieldType> flds = dresponse.getResult().getFields();
        ArrayList<FieldType> fields = null;
        if (flds != null && flds.size() > 0) {
            fields = new ArrayList<FieldType>();
            for (FieldType fld : flds) {
                if (SalesforceSupport.isSystemMaintained(fld.getName()) || SalesforceSupport.isOptional(fld.getName())) continue;
                fields.add(fld);
            }
        }
        if (this.fieldsMap == null) {
            this.fieldsMap = new HashMap<String, List<FieldType>>();
        }
        this.fieldsMap.put(objName, fields);
    }

    private List<FieldType> getFields(String objName) throws Exception {
        List<FieldType> fields;
        if (this.fieldsMap == null) {
            this.setupFields(objName);
            fields = this.fieldsMap.get(objName);
        } else {
            fields = this.fieldsMap.get(objName);
            if (fields == null) {
                this.setupFields(objName);
                fields = this.fieldsMap.get(objName);
            }
        }
        return fields;
    }

    public static String getSalesforceObjName(String className) {
        String name = className;
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            name = name.substring(pos + 1);
        }
        if ((pos = name.lastIndexOf("Type")) > 0 && (name = name.substring(0, pos)).substring(pos - 1).equals("C")) {
            name = name.substring(0, pos - 1) + "__c";
        }
        return name;
    }

    public List<List<Object>> runQuery(Map<String, Class<?>> types, Object ... input) {
        this.executeQuery(types, "executeSforceQueryFromEditor", input);
        ArrayList<List<Object>> rtn = new ArrayList<List<Object>>();
        TreeMap tmap = new TreeMap();
        Set entries = CastUtils.cast((Set)this.resultRows.entrySet());
        for (Map.Entry entry : entries) {
            List list = (List)entry.getValue();
            tmap.put(((Tuple.Two)list.get((int)0)).v1, entry.getKey());
        }
        Set tmapEntries = tmap.entrySet();
        for (Map.Entry entry : tmapEntries) {
            rtn.add((List<Object>)entry.getValue());
        }
        return rtn;
    }

    public List<com.wavemaker.json.JSONObject> runNamedQuery(Map<String, Class<?>> types, Object ... input) {
        this.executeQuery(types, "executeSforceQuery", input);
        ArrayList<com.wavemaker.json.JSONObject> rtn = new ArrayList<com.wavemaker.json.JSONObject>();
        TreeMap tmap = new TreeMap();
        Set entries = CastUtils.cast((Set)this.resultRows.entrySet());
        for (Map.Entry entry : entries) {
            List list = (List)entry.getValue();
            tmap.put(((Tuple.Two)list.get((int)0)).v1, entry.getKey());
        }
        Set tmapEntries = tmap.entrySet();
        for (Map.Entry entry : tmapEntries) {
            rtn.add(this.resultJsonObjs.get(entry.getValue()));
        }
        return rtn;
    }

    private void executeQuery(Map<String, Class<?>> types, String merhodName, Object ... input) {
        try {
            List sobjs;
            String qry = SalesforceSupport.buildQueryString(types, input);
            this.lastQryId = 0;
            this.splitQueries(0, qry, 0);
            int len = input.length;
            PagingOptions po = (PagingOptions)input[len - 1];
            Long psize = po.getMaxResults();
            long firstrec = po.getFirstResult();
            try {
                Class<?> cls = Class.forName("com.sforce.SalesforceCalls");
                Object obj = cls.newInstance();
                Method method = cls.getMethod(merhodName, String.class, Map.class, Object[].class);
                Object[] args = new Object[]{qry, types, input};
                sobjs = (List)method.invoke(obj, args);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            long lastrec = psize != null ? (psize > (long)sobjs.size() - firstrec ? (long)sobjs.size() : psize + firstrec) : (long)sobjs.size();
            this.resultRows = new MultiValueMap();
            this.resultJsonObjs = new HashMap<List<Object>, com.wavemaker.json.JSONObject>();
            this.recId = 0L;
            for (long k = firstrec; k < lastrec; ++k) {
                int ik = new Long(k).intValue();
                Object sobj = sobjs.get(ik);
                SingleQuery sq = this.queryMap.get(1);
                sq.thisObjects.add(sobj);
                Tuple.Two<List<Object>, com.wavemaker.json.JSONObject> tval = this.getFieldValues(sq, sobj);
                List row = (List)tval.v1;
                com.wavemaker.json.JSONObject jsonVal = (com.wavemaker.json.JSONObject)tval.v2;
                Long l = this.recId;
                Long l2 = this.recId = Long.valueOf(this.recId + 1L);
                Tuple.Two t = new Tuple.Two((Object)this.recId, sobj);
                this.resultRows.put((Object)row, (Object)t);
                this.resultJsonObjs.put(row, jsonVal);
                this.setRowsForSubQueries(sq, sobj);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setRowsForSubQueries(SingleQuery psq, Object pobj) throws Exception {
        List<SingleQuery> subQueries = this.getSubqueries(psq);
        if (subQueries != null && subQueries.size() > 0) {
            for (SingleQuery subq : subQueries) {
                this.setQueryResult(subq, pobj);
            }
            this.setSiblingQueryResult(pobj, subQueries);
            for (SingleQuery subq : subQueries) {
                for (Object obj : subq.thisObjects) {
                    this.setRowsForSubQueries(subq, obj);
                }
            }
        }
    }

    private List<List<Object>> getRowsForSforceObject(Object obj) {
        ArrayList<List<Object>> rtn = new ArrayList<List<Object>>();
        Set entries = CastUtils.cast((Set)this.resultRows.entrySet());
        block0: for (Map.Entry entry : entries) {
            List list = (List)entry.getValue();
            for (Tuple.Two elem : list) {
                if (!obj.equals(elem.v2)) continue;
                rtn.add((List<Object>)entry.getKey());
                continue block0;
            }
        }
        return rtn;
    }

    private void setSiblingQueryResult(Object pobj, List<SingleQuery> siblings) {
        List<List<Object>> parentRows = this.getRowsForSforceObject(pobj);
        ArrayList temprows = new ArrayList();
        for (List<Object> parentRow : parentRows) {
            ArrayList rowsArray = new ArrayList();
            ArrayList<Object> temprow = new ArrayList<Object>();
            for (Object val : parentRow) {
                temprow.add(val);
            }
            temprows.add(temprow);
            int startIndx = 0;
            int indx = 0;
            for (SingleQuery qry : siblings) {
                startIndx = indx;
                int cfp = this.getCumFieldPosition(qry, siblings, 0);
                for (List list : temprows) {
                    List<Tuple.Two<List<Object>, com.wavemaker.json.JSONObject>> subqRows = qry.rows.get(pobj);
                    if (subqRows == null) continue;
                    for (Tuple.Two<List<Object>, com.wavemaker.json.JSONObject> subqRow : subqRows) {
                        Object val22;
                        ArrayList rec = new ArrayList();
                        for (Object ival : list) {
                            rec.add(ival);
                        }
                        for (Object val22 : (List)subqRow.v1) {
                            rec.add(cfp, val22);
                        }
                        rowsArray.add(rec);
                        ++indx;
                        Collection objs = CastUtils.cast((Collection)this.resultRows.getCollection((Object)list));
                        val22 = this.recId;
                        Long l = this.recId = Long.valueOf(this.recId + 1L);
                        for (Object obj : objs) {
                            Tuple.Two t = new Tuple.Two((Object)this.recId, obj);
                            this.resultRows.put(rec, (Object)t);
                            this.resultJsonObjs.put(rec, (com.wavemaker.json.JSONObject)subqRow.v2);
                        }
                        Tuple.Two t = new Tuple.Two((Object)this.recId, qry.rowObject.get(subqRow));
                        this.resultRows.put(rec, (Object)t);
                        this.resultJsonObjs.put(rec, (com.wavemaker.json.JSONObject)subqRow.v2);
                    }
                    this.resultRows.remove((Object)list);
                    this.resultJsonObjs.remove(list);
                }
                temprows = new ArrayList();
                for (int i = startIndx; i < indx; ++i) {
                    temprows.add(rowsArray.get(i));
                }
            }
        }
    }

    private int getCumFieldPosition(SingleQuery sq, List<SingleQuery> siblings, int pos) {
        pos = this.traverseParentFieldPosition(sq, pos);
        for (SingleQuery qry : siblings) {
            if (qry.equals(sq)) break;
            pos += qry.fieldList.size() - 1;
        }
        return pos;
    }

    private int traverseParentFieldPosition(SingleQuery sq, int pos) {
        pos += sq.fieldPosition;
        SingleQuery psq = this.queryMap.get(sq.parentQryId);
        if (psq != null) {
            pos = this.traverseParentFieldPosition(psq, pos);
        }
        return pos;
    }

    private void setQueryResult(SingleQuery sq, Object pobj) throws Exception {
        SingleQuery parentsq = this.queryMap.get(sq.parentQryId);
        Class cls = this.getSforceObjectClass(parentsq.objectName);
        String myObjName = SalesforceSupport.getAPISforceObjectShortName(sq.objectName);
        String methodName = "get" + myObjName.substring(0, 1).toUpperCase() + myObjName.substring(1);
        Method method = cls.getMethod(methodName, new Class[0]);
        QueryResultType qryResult = (QueryResultType)method.invoke(pobj, new Object[0]);
        if (qryResult != null) {
            List<SObjectType> rsobjs = qryResult.getRecords();
            ArrayList<Tuple.Two<List<Object>, com.wavemaker.json.JSONObject>> rows = new ArrayList<Tuple.Two<List<Object>, com.wavemaker.json.JSONObject>>();
            for (SObjectType rsobj : rsobjs) {
                sq.thisObjects.add(rsobj);
                Tuple.Two<List<Object>, com.wavemaker.json.JSONObject> tval = this.getFieldValues(sq, rsobj);
                rows.add(tval);
            }
            sq.rows.put(pobj, rows);
        }
    }

    private List<SingleQuery> getSubqueries(SingleQuery sq) {
        List list = (List)this.parentQueryMap.get((Object)sq.qryId);
        return CastUtils.cast((List)list);
    }

    private String getSforceAPIObjectName(String objName) {
        int indx = objName.lastIndexOf(".");
        if (indx > 0) {
            objName = objName.substring(indx + 1);
        }
        objName = objName.replace("__c", "C");
        if ((objName = objName.replace("__r", "R")).equals("FeedTrackedChanges")) {
            objName = "FeedTrackedChange";
        } else if (objName.equals("FeedComments")) {
            objName = "FeedComment";
        }
        return objName;
    }

    private Class getSforceObjectClass(String objName) throws Exception {
        Class<?> cls;
        String apiObjName = this.getSforceAPIObjectName(objName);
        String className = "com.sforce.soap.enterprise.salesforceservice." + apiObjName + "Type";
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            String result = this.loginSvcBean.logIn("sammysm@wavemaker.com", "Silver77Surfer");
            SessionHeader sessionHeader = LoginService.getSessionHeader();
            SforceService service = LoginService.getSforceService();
            DescribeGlobal parameters = new DescribeGlobal();
            DescribeGlobalResponse dresponse = service.describeGlobal(parameters, sessionHeader, null, null);
            List<DescribeGlobalSObjectResultType> sObjects = dresponse.getResult().getSobjects();
            boolean found = false;
            objName = SalesforceSupport.getAPISforceObjectShortName(objName);
            for (DescribeGlobalSObjectResultType obj : sObjects) {
                if (!objName.equals(obj.getLabelPlural())) continue;
                found = true;
                apiObjName = SalesforceSupport.getAPISforceObjectShortName(obj.getName());
            }
            if (!found) {
                throw new ClassNotFoundException();
            }
            className = "com.sforce.soap.enterprise.salesforceservice." + apiObjName + "Type";
            cls = Class.forName(className);
        }
        return cls;
    }

    private Tuple.Two<List<Object>, com.wavemaker.json.JSONObject> getFieldValues(SingleQuery sq, Object sobj) throws Exception {
        Class cls = this.getSforceObjectClass(sq.objectName);
        ArrayList<String> values = new ArrayList<String>();
        com.wavemaker.json.JSONObject jsonValues = new com.wavemaker.json.JSONObject();
        for (String fld : sq.fieldList) {
            String apifld = SalesforceSupport.getAPIFieldName(fld);
            String methodName = "get" + apifld.substring(0, 1).toUpperCase() + apifld.substring(1);
            Method method = cls.getMethod(methodName, new Class[0]);
            Object val = method.invoke(sobj, new Object[0]);
            if (val != null) {
                values.add(val.toString());
                jsonValues.put((Object)fld, val);
                continue;
            }
            values.add(null);
            jsonValues.put((Object)fld, null);
        }
        if (sq.relFieldList != null && sq.relFieldList.size() > 0) {
            Set entries = sq.relFieldList.entrySet();
            for (Map.Entry fldEntry : entries) {
                String objName = SalesforceSupport.getAPISforceObjectShortName((String)fldEntry.getKey());
                String methodName = "get" + objName.substring(0, 1).toUpperCase() + objName.substring(1);
                Method method = cls.getMethod(methodName, new Class[0]);
                Object obj = method.invoke(sobj, new Object[0]);
                List fldList = (List)fldEntry.getValue();
                if (obj != null) {
                    Class<?> subcls = obj.getClass();
                    for (String fld : fldList) {
                        String apifld = SalesforceSupport.getAPIFieldName(fld);
                        methodName = "get" + apifld.substring(0, 1).toUpperCase() + apifld.substring(1);
                        method = subcls.getMethod(methodName, new Class[0]);
                        Object val = method.invoke(obj, new Object[0]);
                        if (val != null) {
                            values.add(val.toString());
                            jsonValues.put((Object)fld, val);
                            continue;
                        }
                        values.add(null);
                        jsonValues.put((Object)fld, val);
                    }
                    continue;
                }
                for (String fld : fldList) {
                    values.add(null);
                    jsonValues.put((Object)fld, null);
                }
            }
        }
        sq.rowObject.put(values, sobj);
        Tuple.Two rtn = new Tuple.Two(values, (Object)jsonValues);
        return rtn;
    }

    private void splitQueries(int parentId, String qry, int pfnum) {
        Tuple.Two<Integer, List<Tuple.Two<String, Integer>>> iqueries = this.getInitSubQueries(parentId, qry, pfnum);
        int pid = (Integer)iqueries.v1;
        List subqueries = (List)iqueries.v2;
        for (Tuple.Two subqry : subqueries) {
            this.splitQueries(pid, (String)subqry.v1, (Integer)subqry.v2);
        }
    }

    private Tuple.Two<Integer, List<Tuple.Two<String, Integer>>> getInitSubQueries(int parentId, String qry, int pfnum) {
        List<String> words = QueryHandler.parseSQL(qry);
        ArrayList<Tuple.Two> qryList = new ArrayList<Tuple.Two>();
        ArrayList<String> fieldList = new ArrayList<String>();
        MultiValueMap relFieldList = new MultiValueMap();
        ++this.lastQryId;
        String objName = null;
        int depth = 0;
        int remainingOpens = 0;
        int counter = 0;
        int qryStartPos = 0;
        boolean inSubQuery = false;
        boolean inFrom = false;
        StringBuffer subQry = new StringBuffer();
        for (String word : words) {
            if (word.equalsIgnoreCase("select")) {
                if (inSubQuery) continue;
                if (depth == 0) {
                    ++depth;
                    continue;
                }
                qryStartPos = counter;
                subQry.append(word);
                subQry.append(" ");
                inSubQuery = true;
                continue;
            }
            if (word.equals(")")) {
                if (!inSubQuery) continue;
                if (remainingOpens == 0) {
                    Tuple.Two elem = new Tuple.Two((Object)subQry.toString(), (Object)qryStartPos);
                    qryList.add(elem);
                    ++counter;
                    subQry.setLength(0);
                    inSubQuery = false;
                    continue;
                }
                --remainingOpens;
                continue;
            }
            if (word.equals("(")) {
                if (!inSubQuery) continue;
                ++remainingOpens;
                continue;
            }
            if (word.equalsIgnoreCase("from")) {
                if (!inSubQuery) {
                    inFrom = true;
                    continue;
                }
                subQry.append(word);
                subQry.append(" ");
                continue;
            }
            if (inSubQuery) {
                subQry.append(word);
                subQry.append(" ");
                continue;
            }
            if (QueryHandler.isDelimiter(word)) continue;
            if (inFrom) {
                objName = word;
                inFrom = false;
                break;
            }
            int indx = word.indexOf(".");
            if (indx < 0) {
                fieldList.add(word);
            } else {
                relFieldList.put((Object)word.substring(0, indx), (Object)word.substring(indx + 1));
            }
            ++counter;
        }
        SingleQuery sq = new SingleQuery(this.lastQryId, parentId, objName, fieldList, relFieldList, pfnum);
        this.queryMap.put(this.lastQryId, sq);
        this.parentQueryMap.put((Object)parentId, (Object)sq);
        Tuple.Two rtn = new Tuple.Two((Object)this.lastQryId, qryList);
        return rtn;
    }

    public static String getAPIFieldName(String fieldName) {
        String rtn = fieldName.replace("__c", "C");
        rtn = rtn.replace("__C", "C");
        return rtn;
    }

    public static String getAPISforceObjectShortName(String objName) {
        int indx = objName.lastIndexOf(".");
        if (indx > 0) {
            objName = objName.substring(indx + 1);
        }
        objName = objName.replace("__c", "C");
        objName = objName.replace("__r", "R");
        objName = objName.replace("__C", "C");
        objName = objName.replace("__R", "R");
        return objName;
    }

    public static String buildQueryString(Map<String, Class<?>> types, Object ... input) {
        PagingOptions po = (PagingOptions)input[input.length - 1];
        Long firstResult = po.getFirstResult();
        Long maxResult = po.getMaxResults();
        if (maxResult != null && (maxResult = Long.valueOf(maxResult - 1L)) < 0L) {
            maxResult = 0L;
        }
        List<String> orderBys = po.getOrderBy();
        String qry = (String)input[0];
        if (input.length > 2) {
            boolean isField = true;
            String field = null;
            for (int i = 1; i < input.length - 1; ++i) {
                if (isField) {
                    field = (String)input[i];
                    isField = false;
                    continue;
                }
                Class<?> type = types.get(field);
                String val = TypeConversionUtils.getValueString(type, (String)input[i].toString());
                qry = qry.replace(":" + field, val);
                isField = true;
            }
        }
        if (orderBys.size() > 0) {
            boolean first = true;
            qry = qry + " order by ";
            for (String orderby : orderBys) {
                if (first) {
                    qry = qry + orderby;
                    first = false;
                    continue;
                }
                qry = qry + ", " + orderby;
            }
        }
        if (maxResult != null) {
            qry = qry + " limit " + maxResult + firstResult;
        }
        return qry;
    }

    private String downShiftFirstChar(String val) {
        val = val.substring(0, 1).toLowerCase() + val.substring(1);
        return val;
    }

    private List<FieldType> getControlPath(FieldType field, Map<String, FieldType> fieldMap, List<FieldType> list) {
        Boolean dependent = field.getDependentPicklist();
        if (dependent == null || !dependent.booleanValue()) {
            return list;
        }
        FieldType controller = fieldMap.get(field.getControllerName());
        if (controller == null) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<FieldType>();
            list.add(field);
        }
        list.add(controller);
        return this.getControlPath(controller, fieldMap, list);
    }

    public static boolean isSystemMaintained(String field) {
        boolean rtn = false;
        for (String name : SYS_MAINT_FIELDS) {
            if (!field.equalsIgnoreCase(name)) continue;
            rtn = true;
            break;
        }
        return rtn;
    }

    public static boolean isOptional(String field) {
        boolean rtn = false;
        for (String name : OPTIONAL_FIELDS) {
            if (!field.equalsIgnoreCase(name)) continue;
            rtn = true;
            break;
        }
        return rtn;
    }

    private FieldType getField(String objName, String fieldName) throws Exception {
        List<FieldType> fields = this.getFields(objName);
        for (FieldType field : fields) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        throw new Exception("Undefined field " + fieldName + " in " + objName);
    }

    private com.wavemaker.json.JSONObject getRestrictedPickList(String objName, FieldType currentField, FieldType controller, com.wavemaker.json.JSONObject fieldAndValuePairs) throws Exception {
        List<PicklistEntryType> picklistValues = currentField.getPicklistValues();
        if (picklistValues == null || picklistValues.size() == 0) {
            return null;
        }
        if (controller == null) {
            return this.prepareJSONObject(picklistValues, fieldAndValuePairs, currentField);
        }
        List<FieldType> fields = this.getFields(objName);
        if (fields == null) {
            return null;
        }
        ArrayList<PicklistEntryType> validValues = new ArrayList<PicklistEntryType>();
        String controlValue = (String)fieldAndValuePairs.get((Object)this.downShiftFirstChar(controller.getName()));
        if (controlValue == null) {
            controlValue = this.getDefaultControlValue(controller);
        }
        block0: for (PicklistEntryType picklistValue : picklistValues) {
            class Bitset {
                byte[] data;

                public Bitset(byte[] data) {
                    this.data = data == null ? new byte[]{} : data;
                }

                public boolean testBit(int n) {
                    return (this.data[n >> 3] & 128 >> n % 8) != 0;
                }

                public int size() {
                    return this.data.length * 8;
                }
            }
            Bitset validFor = new Bitset(picklistValue.getValidFor());
            if ("picklist".equals(controller.getType().value())) {
                for (int k = 0; k < validFor.size(); ++k) {
                    String val;
                    if (!validFor.testBit(k) || !controlValue.equals(val = controller.getPicklistValues().get(k).getValue())) continue;
                    validValues.add(picklistValue);
                    continue block0;
                }
                continue;
            }
            if (!"boolean".equals(controller.getType().value()) || (!validFor.testBit(1) || !"true".equals(controlValue)) && (!validFor.testBit(0) || !"false".equals(controlValue))) continue;
            validValues.add(picklistValue);
        }
        return this.prepareJSONObject(validValues, fieldAndValuePairs, currentField);
    }

    private String getDefaultControlValue(FieldType controller) {
        String rtn = null;
        if ("boolean".equals(controller.getType().value())) {
            rtn = "false";
        } else {
            List<PicklistEntryType> picklistValues = controller.getPicklistValues();
            for (PicklistEntryType entry : picklistValues) {
                if (!entry.isDefaultValue()) continue;
                rtn = entry.getValue();
                break;
            }
            if (rtn == null) {
                rtn = picklistValues.get(0).getValue();
            }
        }
        return rtn;
    }

    private com.wavemaker.json.JSONObject prepareJSONObject(List<PicklistEntryType> picklistValues, com.wavemaker.json.JSONObject fieldAndValuePairs, FieldType currentField) {
        com.wavemaker.json.JSONObject rtn = new com.wavemaker.json.JSONObject();
        JSONArray valArray = new JSONArray();
        com.wavemaker.json.JSONObject defaultObj = null;
        for (PicklistEntryType picklistValue : picklistValues) {
            com.wavemaker.json.JSONObject obj = new com.wavemaker.json.JSONObject();
            obj.put((Object)"name", (Object)picklistValue.getLabel());
            obj.put((Object)"dataValue", (Object)picklistValue.getValue());
            valArray.add((Object)obj);
            if (!picklistValue.isDefaultValue()) continue;
            defaultObj = obj;
        }
        rtn.put((Object)"options", (Object)valArray);
        if (defaultObj == null) {
            defaultObj = (com.wavemaker.json.JSONObject)valArray.get(0);
        }
        rtn.put((Object)"default", defaultObj);
        String defaultValue = defaultObj == null ? picklistValues.get(0).getValue() : (String)defaultObj.get((Object)"dataValue");
        fieldAndValuePairs.put((Object)this.downShiftFirstChar(currentField.getName()), (Object)defaultValue);
        return rtn;
    }

    public static Object convertToQueryReturnType(Class cls, List<com.wavemaker.json.JSONObject> list) {
        ArrayList rtn = new ArrayList();
        Method[] methods = cls.getMethods();
        try {
            for (com.wavemaker.json.JSONObject jsonObj : list) {
                Collection vals = jsonObj.values();
                int i = 0;
                Object obj = cls.newInstance();
                for (Object val : vals) {
                    Method method = SalesforceSupport.getSetMethod(i, methods);
                    method.invoke(obj, val);
                    ++i;
                }
                rtn.add(obj);
            }
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return rtn;
    }

    private static Method getSetMethod(int i, Method[] methods) {
        String name = "setC" + i;
        Method rtn = null;
        for (Method method : methods) {
            String mn = method.getName();
            if (!mn.equals(name)) continue;
            rtn = method;
            break;
        }
        return rtn;
    }

    public List<String> getColumns(String qry) {
        ArrayList<String> rtn = new ArrayList<String>();
        this.splitQueries(0, qry, 0);
        Set<Map.Entry<Integer, SingleQuery>> entries = this.queryMap.entrySet();
        for (Map.Entry<Integer, SingleQuery> entry : entries) {
            SingleQuery sq = entry.getValue();
            rtn.addAll(sq.getQueryFields());
        }
        return rtn;
    }

    public List<String> getColumnTypes(String qry) throws Exception {
        ArrayList<String> rtn = new ArrayList<String>();
        this.splitQueries(0, qry, 0);
        Set<Map.Entry<Integer, SingleQuery>> entries = this.queryMap.entrySet();
        for (Map.Entry<Integer, SingleQuery> entry : entries) {
            SingleQuery sq = entry.getValue();
            this.setupFields(sq.objectName);
            String apiObjName = this.getSforceAPIObjectName(sq.objectName);
            JSONObject jsonObj = WMAppContext.getInstance().getTypesObject();
            JSONObject classesObj = jsonObj.getJSONObject("types");
            String className = "com.sforce.soap.enterprise.salesforceservice." + apiObjName + "Type";
            JSONObject classObj = classesObj.getJSONObject(className);
            JSONObject fieldsObj = classObj.getJSONObject("fields");
            for (String fld : sq.getQueryFields()) {
                fld = SalesforceSupport.getAPIFieldName(fld);
                fld = fld.substring(0, 1).toLowerCase() + fld.substring(1);
                JSONObject fieldObj = fieldsObj.getJSONObject(fld);
                String type = fieldObj.getString("type");
                rtn.add(type);
            }
        }
        return rtn;
    }

    private FieldType getFieldInfo(String objName, String fld) {
        List<FieldType> fields = this.fieldsMap.get(objName);
        FieldType target = null;
        for (FieldType ftype : fields) {
            if (!fld.equals(ftype.getName())) continue;
            target = ftype;
            break;
        }
        if (target == null) {
            throw new WMRuntimeException("ERROR: Invalid field name - " + fld);
        }
        return target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SingleQuery {
        int parentQryId;
        int qryId;
        String objectName;
        MultiValueMap relFieldList;
        List<String> fieldList;
        List<Object> thisObjects = new ArrayList<Object>();
        Map<Object, List<Tuple.Two<List<Object>, com.wavemaker.json.JSONObject>>> rows = new HashMap<Object, List<Tuple.Two<List<Object>, com.wavemaker.json.JSONObject>>>();
        Map<List<Object>, Object> rowObject = new HashMap<List<Object>, Object>();
        int fieldPosition;

        private SingleQuery(int qid, int pqid, String objname, List<String> fldlist, MultiValueMap relfldlist, int pfnum) {
            this.qryId = qid;
            this.parentQryId = pqid;
            this.objectName = objname;
            this.relFieldList = relfldlist;
            this.fieldList = fldlist;
            this.fieldPosition = pfnum;
        }

        public List<String> getQueryFields() {
            ArrayList<String> rtn = new ArrayList<String>();
            for (String fld : this.fieldList) {
                rtn.add(fld);
            }
            Set entries = this.relFieldList.entrySet();
            for (Map.Entry entry : entries) {
                List relflds = (List)entry.getValue();
                for (String fld : relflds) {
                    rtn.add(fld);
                }
            }
            return rtn;
        }
    }
}

