/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import com.wavemaker.json.JSONMarshaller;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.runtime.server.view.TypedView;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonView
extends AbstractView
implements TypedView {
    private static final String DEFAULT_JSON_CONTENT_TYPE = "application/json";
    private JSONState jsonConfig = null;
    private FieldDefinition rootType = null;

    public JsonView() {
        this.setContentType(DEFAULT_JSON_CONTENT_TYPE);
    }

    protected void createJSON(Map<?, ?> model, Writer writer) throws IOException {
        if (model.size() == 1 && model.containsKey("WM_ROOT_MODEL_OBJECT_KEY")) {
            this.defaultCreateJSON(writer, model.get("WM_ROOT_MODEL_OBJECT_KEY"));
        } else {
            this.defaultCreateJSON(writer, model);
        }
    }

    protected final void defaultCreateJSON(Writer writer, Object obj) throws IOException {
        JSONMarshaller.marshal((Writer)writer, (Object)obj, (JSONState)this.jsonConfig, (FieldDefinition)this.rootType, (boolean)false, (boolean)false);
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        PrintWriter w = response.getWriter();
        this.createJSON(model, w);
        ((Writer)w).close();
    }

    public JSONState getJsonConfig() {
        return this.jsonConfig;
    }

    public void setJsonConfig(JSONState jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    @Override
    public FieldDefinition getRootType() {
        return this.rootType;
    }

    @Override
    public void setRootType(FieldDefinition type) {
        this.rootType = type;
    }
}

