/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.json.core;

import com.wavemaker.common.WMRuntimeException;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtils {
    public static String quote(String string) {
        StringBuffer ret = new StringBuffer(string.length() + 2);
        ret.append('\"');
        block9: for (char character : string.toCharArray()) {
            switch (character) {
                case '\"': {
                    ret.append('\\');
                    ret.append('\"');
                    continue block9;
                }
                case '\\': {
                    ret.append('\\');
                    ret.append('\\');
                    continue block9;
                }
                case '\b': {
                    ret.append('\\');
                    ret.append('b');
                    continue block9;
                }
                case '\f': {
                    ret.append('\\');
                    ret.append('f');
                    continue block9;
                }
                case '\n': {
                    ret.append('\\');
                    ret.append('n');
                    continue block9;
                }
                case '\r': {
                    ret.append('\\');
                    ret.append('r');
                    continue block9;
                }
                case '\t': {
                    ret.append('\\');
                    ret.append('t');
                    continue block9;
                }
                default: {
                    ret.append(character);
                }
            }
        }
        ret.append('\"');
        return ret.toString();
    }

    public static String numberToString(Number n) {
        if (n == null) {
            throw new WMRuntimeException("Null pointer");
        }
        JSONUtils.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static void testValidity(Object o) {
        if (o != null) {
            if (o instanceof Double) {
                if (((Double)o).isInfinite() || ((Double)o).isNaN()) {
                    throw new WMRuntimeException("JSON does not allow non-finite numbers");
                }
            } else if (o instanceof Float) {
                if (((Float)o).isInfinite() || ((Float)o).isNaN()) {
                    throw new WMRuntimeException("JSON does not allow non-finite numbers.");
                }
            } else if (o instanceof BigDecimal || o instanceof BigInteger) {
                return;
            }
        }
    }

    public static boolean isNumber(Class<?> clazz) {
        return clazz != null && (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz));
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz != null && (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz));
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz));
    }

    public static boolean isPrimitive(Class<?> klass) {
        if (CharSequence.class.isAssignableFrom(klass)) {
            return true;
        }
        if (Character.TYPE.isAssignableFrom(klass) || Character.class.isAssignableFrom(klass)) {
            return true;
        }
        if (JSONUtils.isNumber(klass)) {
            return true;
        }
        if (JSONUtils.isBoolean(klass)) {
            return true;
        }
        if (klass.isEnum() || null != klass.getDeclaringClass() && klass.getDeclaringClass().isEnum()) {
            return true;
        }
        return Class.class.isAssignableFrom(klass);
    }
}

