/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.json.type.reflect;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.json.JSON;
import com.wavemaker.json.core.JSONUtils;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.GenericFieldDefinition;
import com.wavemaker.json.type.ListTypeDefinition;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.EnumPrimitiveReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ListReflectTypeDefinition;
import com.wavemaker.json.type.reflect.MapReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ObjectReflectTypeDefinition;
import com.wavemaker.json.type.reflect.PrimitiveReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeState;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.log4j.Logger;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectTypeUtils {
    protected static final Logger logger = Logger.getLogger(ReflectTypeUtils.class);

    public static ListTypeDefinition getListTypeDefinition(Type type, TypeState typeState, boolean strict) {
        ListReflectTypeDefinition lrtd = new ListReflectTypeDefinition();
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (typeState.isTypeKnown(ReflectTypeUtils.getTypeName(klass))) {
                return (ListTypeDefinition)typeState.getType(ReflectTypeUtils.getTypeName(klass));
            }
            lrtd.setKlass(klass);
            lrtd.setTypeName(ReflectTypeUtils.getTypeName(type));
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            if (!(pt.getRawType() instanceof Class)) {
                throw new WMRuntimeException(Resource.JSON_RAW_TYPE_NOT_CLASS, new Object[]{pt.getRawType()});
            }
            Class klass = (Class)pt.getRawType();
            if (!Collection.class.isAssignableFrom(klass)) {
                throw new WMRuntimeException(Resource.JSON_EXPECTED_COLLECTION, new Object[]{klass});
            }
            if (null != typeState.getType(ReflectTypeUtils.getTypeName(klass))) {
                return (ListTypeDefinition)typeState.getType(ReflectTypeUtils.getTypeName(klass));
            }
            lrtd.setKlass(klass);
            lrtd.setTypeName(ReflectTypeUtils.getTypeName(type));
        } else {
            throw new WMRuntimeException(Resource.JSON_UNKNOWN_TYPE, new Object[]{type});
        }
        typeState.addType(lrtd);
        return lrtd;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeDefinition getTypeDefinition(Type type, TypeState typeState, boolean strict) {
        void var4_19;
        if (typeState.isTypeKnown(ReflectTypeUtils.getTypeName(type))) {
            return typeState.getType(ReflectTypeUtils.getTypeName(type));
        }
        if (type instanceof Class && Object.class.equals((Object)type)) {
            return null;
        }
        if (!strict) {
            if (type instanceof Class && Map.class.isAssignableFrom((Class)type) && !Properties.class.isAssignableFrom((Class)type)) {
                if (JSON.class.isAssignableFrom((Class)type)) return null;
                logger.warn((Object)Resource.JSON_TYPE_NOGENERICS.getMessage(new Object[]{type}));
                return null;
            }
            if (type instanceof Class && List.class.isAssignableFrom((Class)type)) {
                if (JSON.class.isAssignableFrom((Class)type)) return null;
                logger.warn((Object)Resource.JSON_TYPE_NOGENERICS.getMessage(new Object[]{type}));
                return null;
            }
        }
        if (type instanceof Class && Properties.class.isAssignableFrom((Class)type)) {
            MapReflectTypeDefinition mtdret = new MapReflectTypeDefinition();
            mtdret.setTypeName(ReflectTypeUtils.getTypeName(type));
            mtdret.setShortName(ReflectTypeUtils.getShortName(type));
            typeState.addType(mtdret);
            Class klass = (Class)type;
            mtdret.setKlass(klass);
            TypeDefinition stringType = ReflectTypeUtils.getTypeDefinition(String.class, typeState, false);
            mtdret.setKeyFieldDefinition(new GenericFieldDefinition(stringType));
            mtdret.setValueFieldDefinition(new GenericFieldDefinition(stringType));
            MapReflectTypeDefinition mapReflectTypeDefinition = mtdret;
            return var4_19;
        } else if (type instanceof Class && JSONUtils.isPrimitive((Class)type)) {
            PrimitiveReflectTypeDefinition ptret = ((Class)type).isEnum() ? new EnumPrimitiveReflectTypeDefinition() : new PrimitiveReflectTypeDefinition();
            ptret.setTypeName(ReflectTypeUtils.getTypeName(type));
            ptret.setShortName(ReflectTypeUtils.getShortName(type));
            typeState.addType(ptret);
            Class klass = (Class)type;
            ptret.setKlass(klass);
            PrimitiveReflectTypeDefinition primitiveReflectTypeDefinition = ptret;
            return var4_19;
        } else if (type instanceof Class) {
            Class klass = (Class)type;
            if (Collection.class.isAssignableFrom(klass)) {
                throw new WMRuntimeException(Resource.JSON_TYPE_NOGENERICS, new Object[]{klass});
            }
            if (klass.isArray()) {
                throw new WMRuntimeException(Resource.JSON_USE_FIELD_FOR_ARRAY, new Object[]{klass});
            }
            if (Map.class.isAssignableFrom(klass)) {
                throw new WMRuntimeException(Resource.JSON_TYPE_NOGENERICS, new Object[]{klass});
            }
            if (ClassUtils.isPrimitiveOrWrapper((Class)klass) || CharSequence.class.isAssignableFrom(klass)) {
                PrimitiveReflectTypeDefinition ptret = new PrimitiveReflectTypeDefinition();
                ptret.setTypeName(ReflectTypeUtils.getTypeName(type));
                ptret.setShortName(ReflectTypeUtils.getShortName(type));
                typeState.addType(ptret);
                ptret.setKlass(klass);
                PrimitiveReflectTypeDefinition primitiveReflectTypeDefinition = ptret;
                return var4_19;
            } else {
                ObjectReflectTypeDefinition otret = new ObjectReflectTypeDefinition();
                otret.setTypeName(ReflectTypeUtils.getTypeName(type));
                otret.setShortName(ReflectTypeUtils.getShortName(type));
                otret.setKlass(klass);
                typeState.addType(otret);
                PropertyUtilsBean pub = ((ReflectTypeState)typeState).getPropertyUtilsBean();
                PropertyDescriptor[] pds = pub.getPropertyDescriptors(klass);
                otret.setFields(new LinkedHashMap<String, FieldDefinition>(pds.length));
                for (PropertyDescriptor pd : pds) {
                    Type paramType;
                    if (pd.getName().equals("class")) continue;
                    if (null != pd.getReadMethod()) {
                        paramType = pd.getReadMethod().getGenericReturnType();
                    } else if (null != pd.getWriteMethod()) {
                        paramType = pd.getWriteMethod().getGenericParameterTypes()[0];
                    } else {
                        logger.warn((Object)("No getter in type " + pd.getName()));
                        continue;
                    }
                    otret.getFields().put(pd.getName(), ReflectTypeUtils.getFieldDefinition(paramType, typeState, strict, pd.getName()));
                }
                ObjectReflectTypeDefinition objectReflectTypeDefinition = otret;
            }
            return var4_19;
        } else {
            if (!(type instanceof ParameterizedType)) throw new WMRuntimeException(Resource.JSON_TYPE_UNKNOWNPARAMTYPE, new Object[]{type, null != type ? type.getClass() : null});
            ParameterizedType pt = (ParameterizedType)type;
            if (!(pt.getRawType() instanceof Class) || !Map.class.isAssignableFrom((Class)pt.getRawType())) throw new WMRuntimeException(Resource.JSON_TYPE_UNKNOWNRAWTYPE, new Object[]{pt.getOwnerType(), pt});
            MapReflectTypeDefinition mtdret = new MapReflectTypeDefinition();
            mtdret.setTypeName(ReflectTypeUtils.getTypeName(type));
            mtdret.setShortName(ReflectTypeUtils.getShortName(type));
            typeState.addType(mtdret);
            Type[] types = pt.getActualTypeArguments();
            mtdret.setKeyFieldDefinition(ReflectTypeUtils.getFieldDefinition(types[0], typeState, strict, null));
            mtdret.setValueFieldDefinition(ReflectTypeUtils.getFieldDefinition(types[1], typeState, strict, null));
            mtdret.setKlass((Class)pt.getRawType());
            MapReflectTypeDefinition mapReflectTypeDefinition = mtdret;
        }
        return var4_19;
    }

    public static FieldDefinition getFieldDefinition(Method method, TypeState typeState, boolean strict, String name) {
        return ReflectTypeUtils.getFieldDefinition(method.getGenericReturnType(), typeState, strict, name);
    }

    public static FieldDefinition getFieldDefinition(Type type, TypeState typeState, boolean strict, String name) {
        GenericFieldDefinition ret = new GenericFieldDefinition();
        ret.setName(name);
        if (null != type) {
            if (type instanceof Class) {
                Class returnTypeClass = (Class)type;
                if (returnTypeClass.isArray()) {
                    Tuple.Two<TypeDefinition, List<ListTypeDefinition>> dimAndClass = ReflectTypeUtils.getArrayDimensions(returnTypeClass, typeState, strict);
                    ret.setTypeDefinition((TypeDefinition)dimAndClass.v1);
                    ret.setArrayTypes((List)dimAndClass.v2);
                } else if (!strict && Collection.class.isAssignableFrom(returnTypeClass)) {
                    if (!JSON.class.isAssignableFrom(returnTypeClass)) {
                        logger.warn((Object)Resource.JSON_TYPE_NOGENERICS.getMessage(new Object[]{returnTypeClass}));
                    }
                    ret.setArrayTypes(new ArrayList<ListTypeDefinition>(1));
                    ret.getArrayTypes().add(ReflectTypeUtils.getListTypeDefinition(returnTypeClass, typeState, strict));
                } else if (ClassUtils.isPrimitiveOrWrapper((Class)returnTypeClass)) {
                    TypeDefinition td = ReflectTypeUtils.getTypeDefinition(returnTypeClass, typeState, strict);
                    ret.setTypeDefinition(td);
                } else {
                    TypeDefinition td = ReflectTypeUtils.getTypeDefinition(returnTypeClass, typeState, strict);
                    ret.setTypeDefinition(td);
                }
            } else if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                if (Class.class == pt.getRawType()) {
                    TypeDefinition td = ReflectTypeUtils.getTypeDefinition(Class.class, typeState, strict);
                    ret.setTypeDefinition(td);
                } else if (pt.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)pt.getRawType())) {
                    Tuple.Two<TypeDefinition, List<ListTypeDefinition>> dimAndClass = ReflectTypeUtils.getArrayDimensions(pt, typeState, strict);
                    ret.setTypeDefinition((TypeDefinition)dimAndClass.v1);
                    ret.setArrayTypes((List)dimAndClass.v2);
                } else if (pt.getRawType() instanceof Class && Map.class.isAssignableFrom((Class)pt.getRawType())) {
                    TypeDefinition td = ReflectTypeUtils.getTypeDefinition(pt, typeState, strict);
                    ret.setTypeDefinition(td);
                } else {
                    if (strict) {
                        throw new WMRuntimeException(Resource.JSON_TYPE_UNKNOWNRAWTYPE, new Object[]{pt.getOwnerType(), pt});
                    }
                    logger.warn((Object)Resource.JSON_TYPE_UNKNOWNRAWTYPE.getMessage(new Object[]{pt.getOwnerType(), pt}));
                }
            } else if (type instanceof GenericArrayType) {
                Tuple.Two<TypeDefinition, List<ListTypeDefinition>> dimAndClass = ReflectTypeUtils.getArrayDimensions(type, typeState, strict);
                ret.setTypeDefinition((TypeDefinition)dimAndClass.v1);
                ret.setArrayTypes((List)dimAndClass.v2);
            } else {
                throw new WMRuntimeException(Resource.JSON_TYPE_UNKNOWNPARAMTYPE, new Object[]{type, null != type ? type.getClass() : null});
            }
        }
        return ret;
    }

    protected static Tuple.Two<TypeDefinition, List<ListTypeDefinition>> getArrayDimensions(Type type, TypeState typeState, boolean strict) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] types = pt.getActualTypeArguments();
            if (1 == types.length) {
                Tuple.Two<TypeDefinition, List<ListTypeDefinition>> temp = ReflectTypeUtils.getArrayDimensions(types[0], typeState, strict);
                ((List)temp.v2).add(0, ReflectTypeUtils.getListTypeDefinition(pt.getRawType(), typeState, strict));
                return temp;
            }
            return new Tuple.Two((Object)ReflectTypeUtils.getTypeDefinition(pt, typeState, strict), new ArrayList());
        }
        if (type instanceof GenericArrayType) {
            Class<?> klass;
            GenericArrayType gat = (GenericArrayType)type;
            try {
                klass = ClassUtils.forName((String)gat.toString());
            }
            catch (ClassNotFoundException e) {
                klass = null;
            }
            catch (LinkageError e) {
                klass = null;
            }
            if (null == klass && gat.getGenericComponentType() instanceof Class) {
                klass = Array.newInstance((Class)gat.getGenericComponentType(), 0).getClass();
            }
            if (null == klass) {
                throw new WMRuntimeException(Resource.JSON_FAILED_GENERICARRAYTYPE, new Object[]{gat, gat.getGenericComponentType()});
            }
            Tuple.Two<TypeDefinition, List<ListTypeDefinition>> temp = ReflectTypeUtils.getArrayDimensions(gat.getGenericComponentType(), typeState, strict);
            ((List)temp.v2).add(0, ReflectTypeUtils.getListTypeDefinition(klass, typeState, strict));
            return temp;
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Tuple.Two<TypeDefinition, List<ListTypeDefinition>> temp = ReflectTypeUtils.getArrayDimensions(((Class)type).getComponentType(), typeState, strict);
            ((List)temp.v2).add(0, ReflectTypeUtils.getListTypeDefinition(type, typeState, strict));
            return temp;
        }
        if (type instanceof Class) {
            return new Tuple.Two((Object)ReflectTypeUtils.getTypeDefinition(type, typeState, strict), new ArrayList());
        }
        throw new WMRuntimeException(Resource.JSON_TYPE_UNKNOWNPARAMTYPE, new Object[]{type, null != type ? type.getClass() : null});
    }

    public static String getTypeName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof ParameterizedType) {
            return type.toString().replace(" ", "");
        }
        throw new WMRuntimeException(Resource.JSON_TYPE_UNKNOWNPARAMTYPE, new Object[]{type, null != type ? type.getClass() : null});
    }

    public static String getShortName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return null;
    }
}

