/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.json.type.reflect.converters;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.JSONMarshaller;
import com.wavemaker.json.type.converters.ReadObjectConverter;
import com.wavemaker.json.type.converters.WriteObjectConverter;
import com.wavemaker.json.type.reflect.PrimitiveReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import java.io.IOException;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTypeDefinition
extends PrimitiveReflectTypeDefinition
implements ReadObjectConverter,
WriteObjectConverter {
    public DateTypeDefinition(Class<? extends Date> klass) {
        this.setKlass(klass);
        this.setTypeName(ReflectTypeUtils.getTypeName(this.getKlass()));
    }

    @Override
    public Object readObject(Object input, Object root, String path) {
        if (null == input) {
            return null;
        }
        if (Number.class.isAssignableFrom(input.getClass())) {
            Number num = (Number)input;
            if (Date.class.equals(this.getKlass())) {
                return new Date(num.longValue());
            }
            if (java.sql.Date.class.equals(this.getKlass())) {
                return new java.sql.Date(num.longValue());
            }
            if (Timestamp.class.equals(this.getKlass())) {
                return new Timestamp(num.longValue());
            }
            if (Time.class.equals(this.getKlass())) {
                return new Time(num.longValue());
            }
            throw new WMRuntimeException(Resource.JSON_UNHANDLED_TYPE, new Object[]{input, input.getClass()});
        }
        return input;
    }

    @Override
    public void writeObject(Object input, Object root, String path, Writer writer) throws IOException {
        if (null == input) {
            JSONMarshaller.marshal(writer, input);
        } else if (Date.class.isAssignableFrom(input.getClass())) {
            writer.write("" + ((Date)input).getTime());
        } else {
            throw new WMRuntimeException(Resource.JSON_UNHANDLED_TYPE, new Object[]{input, input.getClass()});
        }
    }
}

