/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ThrowawayFileClassLoader;
import com.wavemaker.common.util.TypeConversionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static Class<?> loadClass(String className) {
        return ClassLoaderUtils.loadClass(className, ClassLoaderUtils.getClassLoader());
    }

    public static Class<?> loadClass(String className, boolean initialize) {
        return ClassLoaderUtils.loadClass(className, initialize, ClassLoaderUtils.getClassLoader());
    }

    public static Class<?> loadClass(String className, ClassLoader loader) {
        return ClassLoaderUtils.loadClass(className, true, loader);
    }

    public static Class<?> loadClass(String className, boolean initialize, ClassLoader loader) {
        try {
            Class<?> rtn = TypeConversionUtils.primitiveForName(className);
            if (rtn == null) {
                rtn = Class.forName(className, initialize, loader);
            }
            return rtn;
        }
        catch (ClassNotFoundException ex) {
            String s = ex.getMessage();
            if (s == null || s.equals("")) {
                s = "Cannot find class " + className;
            }
            throw new WMRuntimeException(s, (Throwable)ex);
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static String getResource(String path) {
        URL url = ClassLoaderUtils.getClassLoader().getResource(path);
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    public static InputStream getResourceAsStream(String path) {
        return ClassLoaderUtils.getClassLoader().getResourceAsStream(path);
    }

    public static InputStream getResourceAsStream(String path, ClassLoader cl) {
        return cl.getResourceAsStream(path);
    }

    public static ClassLoader getClassLoaderForFile(File ... files) {
        return ClassLoaderUtils.getClassLoaderForFile(ClassLoaderUtils.getClassLoader(), files);
    }

    public static ClassLoader getClassLoaderForFile(ClassLoader parent, File ... files) {
        try {
            final ClassLoader parentF = parent;
            final URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
            URLClassLoader ret = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(urls, parentF);
                }
            });
            return ret;
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static ClassLoader getTempClassLoaderForFile(File ... files) {
        final List<File> filesL = Arrays.asList(files);
        ClassLoader ret = AccessController.doPrivileged(new PrivilegedAction<ThrowawayFileClassLoader>(){

            @Override
            public ThrowawayFileClassLoader run() {
                return new ThrowawayFileClassLoader(filesL, ClassLoaderUtils.getClassLoader().getParent());
            }
        });
        return ret;
    }

    public static File getClasspathFile(String path) throws IOException {
        File ret = new ClassPathResource(path).getFile();
        if (!ret.exists()) {
            throw new IOException("Cannot access " + ret.getAbsolutePath());
        }
        return ret;
    }

    public static Object runInClassLoaderContext(TaskType task, File ... files) {
        return ClassLoaderUtils.runInClassLoaderContext(task, ClassLoaderUtils.getClassLoaderForFile(files));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runInClassLoaderContext(TaskType task, ClassLoader cl) {
        ClassLoader c = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            if (task instanceof TaskRtn) {
                Object object = ((TaskRtn)task).run();
                return object;
            }
            ((TaskNoRtn)task).run();
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            Thread.currentThread().setContextClassLoader(c);
        }
    }

    public static interface TaskRtn
    extends TaskType {
        public Object run();
    }

    public static interface TaskNoRtn
    extends TaskType {
        public void run();
    }

    private static interface TaskType {
    }
}

