/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    public static Object newInstance(Class<?> c) {
        try {
            return c.newInstance();
        }
        catch (InstantiationException ex) {
            String s = ex.getMessage();
            if (s == null || s.equals("")) {
                s = "Failed to instantiate " + c.getName();
            }
            throw new WMRuntimeException(s, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new WMRuntimeException(ex);
        }
    }

    public static List<Method> getPublicMethods(Class<?> c) {
        Method[] allMethods = c.getMethods();
        ArrayList<Method> ret = new ArrayList<Method>(allMethods.length);
        for (int i = 0; i < allMethods.length; ++i) {
            if (allMethods[i].getDeclaringClass().equals(Object.class)) continue;
            ret.add(allMethods[i]);
        }
        return ret;
    }

    public static List<Field> getPublicFields(Class<?> c) {
        return ClassUtils.getPublicFields(c, null);
    }

    public static List<Field> getPublicFields(Class<?> c, Class<?> fieldType) {
        ArrayList<Field> rtn = new ArrayList<Field>();
        Field[] f = c.getFields();
        for (int i = 0; i < f.length; ++i) {
            if (fieldType != null && !fieldType.isAssignableFrom(f[i].getType())) continue;
            rtn.add(f[i]);
        }
        return rtn;
    }

    public static String getPropertyGetterName(String propertyName) {
        return "get" + StringUtils.upperCaseFirstLetter(propertyName);
    }

    public static String getAltPropertyGetterName(String propertyName) {
        return "is" + StringUtils.upperCaseFirstLetter(propertyName);
    }

    public static String getPropertySetterName(String propertyName) {
        return "set" + StringUtils.upperCaseFirstLetter(propertyName);
    }

    private ClassUtils() {
        throw new UnsupportedOperationException();
    }
}

