/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.ObjectGraphTraversal;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtils {
    private static final Class<?>[] simpleTypes = new Class[]{Integer.TYPE, Integer.class, String.class, Date.class};

    public static String getId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }

    public static boolean isNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static boolean isNullOrEmpty(Object[] o) {
        if (o == null) {
            return true;
        }
        return o.length == 0;
    }

    public static boolean isNullOrEmpty(List<?> l) {
        if (l == null) {
            return true;
        }
        return l.isEmpty();
    }

    public static Object[] addArrays(Object[] ... o) {
        Class<Object> rtnType = o[0].getClass().getComponentType();
        for (int i = 1; i < o.length; ++i) {
            if (o[i].getClass().getComponentType().equals(rtnType)) continue;
            rtnType = Object.class;
            break;
        }
        int totalLength = 0;
        for (int i = 0; i < o.length; ++i) {
            totalLength += o[i].length;
        }
        Object[] rtn = (Object[])Array.newInstance(rtnType, totalLength);
        int destPos = 0;
        for (int i = 0; i < o.length; ++i) {
            System.arraycopy(o[i], 0, rtn, destPos, o[i].length);
            destPos += o[i].length;
        }
        return rtn;
    }

    public static Object[] toArray(Collection<?> c, Class<?> arrayType) {
        Object[] rtn = (Object[])Array.newInstance(arrayType, c.size());
        int i = 0;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            rtn[i++] = iter.next();
        }
        return rtn;
    }

    public static String toString(Object[] array) {
        return ObjectUtils.toString(array, ", ");
    }

    public static String toString(Object[] array, String sep) {
        if (array == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(String.valueOf(array[i]));
            if (i >= array.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String toString(Collection c) {
        return ObjectUtils.toString(c, ", ");
    }

    public static String toString(Collection c, String sep) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            sb.append(String.valueOf(iter.next()));
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static Collection<?> map(String[] funcNames, Collection<?> c) {
        ArrayList rtn = new ArrayList(c.size());
        Method[] methods = new Method[funcNames.length];
        for (Object o : c) {
            for (int i = 0; i < funcNames.length; ++i) {
                if (methods[i] == null) {
                    try {
                        methods[i] = o.getClass().getMethod(funcNames[i], null);
                    }
                    catch (Exception ex) {
                        throw new WMRuntimeException(ex);
                    }
                }
                try {
                    o = methods[i].invoke(o, (Object[])null);
                    continue;
                }
                catch (Exception ex) {
                    throw new WMRuntimeException(ex);
                }
            }
            rtn.add(o);
        }
        return rtn;
    }

    public static String objectToString(Object o) {
        ObjectAccess a = ObjectAccess.getInstance();
        return a.objectToString(o);
    }

    public static String objectToStringRecursive(Object o) {
        final StringBuilder sb = new StringBuilder();
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            int i = 0;
            for (Object item : c) {
                sb.append("element ").append(i).append(" in root Collection:\n");
                sb.append(ObjectUtils.objectToStringRecursive(item));
                sb.append("\n");
            }
            return sb.toString();
        }
        sb.append("root: " + ObjectUtils.objectToString(o));
        if (o == null) {
            return sb.toString();
        }
        final ObjectAccess oa = ObjectAccess.getInstance();
        ObjectGraphTraversal.ObjectVisitor v = new ObjectGraphTraversal.ObjectVisitor(){

            public void visit(Object o, ObjectGraphTraversal.Context ctx) {
                sb.append("\n" + ctx.getPropertyPath() + ": " + ObjectUtils.objectToString(o));
            }

            public void cycle(Object o, ObjectGraphTraversal.Context ctx) {
                sb.append("\n" + ctx.getPropertyPath() + ": Cycle");
            }
        };
        ObjectGraphTraversal.PropertyFactory p = new ObjectGraphTraversal.PropertyFactory(){

            public List<String> getProperties(Object o, ObjectGraphTraversal.Context ctx) {
                return oa.getPropertyNames(o.getClass());
            }
        };
        new ObjectGraphTraversal(p, v).traverse(o);
        return sb.toString();
    }

    public static String diffObjects(Object o1, Object o2) {
        if (o1.getClass() != o2.getClass()) {
            throw new IllegalArgumentException("Arguments o1 and o2 must be of same type");
        }
        StringBuilder rtn = new StringBuilder();
        List<Method> getters = ObjectUtils.getSimpleGetters(o1.getClass());
        for (Method m : getters) {
            try {
                Object r1 = m.invoke(o1, (Object[])null);
                Object r2 = m.invoke(o2, (Object[])null);
                if ((r1 != null || r2 == null) && r1.equals(r2)) continue;
                rtn.append(m.getName()).append(": ").append(r1).append(" != ").append(r2).append("\n");
            }
            catch (Exception ex) {
                throw new WMRuntimeException(ex);
            }
        }
        return rtn.toString();
    }

    private static List<?> getSimpleGetters(Class<?> c) {
        return ObjectUtils.filterMethods(c.getDeclaredMethods(), new String[]{"get"}, simpleTypes);
    }

    private static List<Method> filterMethods(Method[] methods, String[] names, Class<?>[] rtnTypes) {
        ArrayList<Method> rtn = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            for (int n = 0; n < names.length; ++n) {
                if (!methods[i].getName().startsWith(names[n])) continue;
                for (int t = 0; t < rtnTypes.length; ++t) {
                    if (methods[i].getReturnType() != rtnTypes[t]) continue;
                    rtn.add(methods[i]);
                }
            }
        }
        return rtn;
    }

    private static Class<?> getArrayType_ClassMatch(Class<?> oldC, Class<?> newC) {
        Class<Object> ret = null == oldC ? newC : (oldC.equals(newC) ? oldC : null);
        return ret;
    }

    public static Class<?> getArrayType(Object array) {
        Class<?> arrayType;
        if (null == array) {
            throw new IllegalArgumentException("Argument must be an array or a collection, not " + array);
        }
        if (array.getClass().isArray()) {
            arrayType = array.getClass().getComponentType();
            if (arrayType.equals(Object.class)) {
                Object elem;
                arrayType = null;
                Object[] arr$ = (Object[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && null != (arrayType = ObjectUtils.getArrayType_ClassMatch(arrayType, (elem = arr$[i$]).getClass())); ++i$) {
                }
            }
        } else if (array instanceof Collection) {
            Object elem;
            Collection c = (Collection)array;
            if (c.isEmpty()) {
                return String.class;
            }
            arrayType = null;
            Iterator i$ = c.iterator();
            while (i$.hasNext() && null != (arrayType = ObjectUtils.getArrayType_ClassMatch(arrayType, (elem = i$.next()).getClass()))) {
            }
        } else {
            throw new IllegalArgumentException("Argument must be an array or a collection, not " + array.getClass());
        }
        return arrayType;
    }

    public static Collection<String> getKeysStartingWith(String prefix, Map<String, ?> m) {
        HashSet<String> rtn = new HashSet<String>();
        for (String s : m.keySet()) {
            if (!s.startsWith(prefix)) continue;
            rtn.add(s);
        }
        return rtn;
    }

    public static boolean strCmp(Object o1, Object o2) {
        return String.valueOf(o1).equals(String.valueOf(o2));
    }

    private ObjectUtils() {
        throw new UnsupportedOperationException();
    }
}

