/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.ClassUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyMap<K, V> {
    private final Map<K, Set<V>> m;

    public OneToManyMap() {
        this(HashMap.class);
    }

    public OneToManyMap(Class<?> mapType) {
        this.m = CastUtils.cast((Map)ClassUtils.newInstance(mapType));
    }

    public V put(K key, V value) {
        Set<V> l = this.m.get(key);
        if (l == null) {
            l = new HashSet<V>();
            this.m.put(key, l);
        }
        V rtn = null;
        if (l.contains(value)) {
            rtn = value;
        } else {
            l.add(value);
        }
        return rtn;
    }

    public Collection<V> get(Object key) {
        return this.m.get(key);
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getValues().contains(value);
    }

    public void removeValue(Object key, Object value) {
        Collection c = this.m.get(key);
        if (c != null) {
            c.remove(value);
        }
    }

    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return Collections.unmodifiableSet(this.m.entrySet());
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.m.keySet());
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        return this.m.remove(key);
    }

    public int size() {
        return this.m.size();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.getValues());
    }

    private Collection<V> getValues() {
        HashSet<V> rtn = new HashSet<V>();
        for (Set<V> s : this.m.values()) {
            rtn.addAll(s);
        }
        return rtn;
    }
}

