/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.WMException;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.CastUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemUtils {
    private static final byte[] KEY = new byte[]{12, 7, 28, 127, 97, 69, 77, 122, 11};
    private static final String ENCRYPTED_PREFIX = "wm_-+";
    private static final String ENCRYPTED_SUFFIX = "==wm-_";

    public static String encrypt(String s) {
        s = ENCRYPTED_PREFIX + s + ENCRYPTED_SUFFIX;
        StringBuilder rtn = new StringBuilder(s.length());
        byte[] bytes = s.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            rtn.append(SystemUtils.encrypt(bytes[i], KEY[i % KEY.length]));
        }
        return rtn.toString();
    }

    public static String decrypt(String s) {
        return SystemUtils.decrypt(s, true);
    }

    private static String decrypt(String s, boolean removeMarkers) {
        byte[] rtn = new byte[s.length() / 2];
        int j = 0;
        for (int i = 0; i < s.length(); i += 2) {
            String hex = s.substring(i, i + 2);
            rtn[j] = (byte)(Integer.parseInt(hex, 16) ^ KEY[j % KEY.length]);
            ++j;
        }
        String d = new String(rtn);
        if (removeMarkers && SystemUtils.hasMarkers(d)) {
            return d.substring(ENCRYPTED_PREFIX.length(), d.length() - ENCRYPTED_SUFFIX.length());
        }
        return d;
    }

    public static boolean isEncrypted(String s) {
        if (s == null) {
            return false;
        }
        try {
            String d = SystemUtils.decrypt(s, false);
            return SystemUtils.hasMarkers(d);
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private static boolean hasMarkers(String s) {
        return s.startsWith(ENCRYPTED_PREFIX) && s.endsWith(ENCRYPTED_SUFFIX);
    }

    private static String encrypt(byte b, byte key) {
        String rtn = Integer.toHexString(b = (byte)(b ^ key));
        if (rtn.length() == 1) {
            rtn = "0" + rtn;
        }
        return rtn;
    }

    public static long getUnsignedValue(byte[] bytes) {
        long rtn = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            boolean isSignBitSet;
            byte b = bytes[i];
            boolean bl = isSignBitSet = (b & 0x80) == 128;
            if (isSignBitSet) {
                b = (byte)(b & 0x7F);
            }
            rtn |= (long)b;
            if (isSignBitSet) {
                rtn |= 0x80L;
            }
            if (i >= bytes.length - 1) continue;
            rtn <<= 8;
        }
        return rtn;
    }

    public static Throwable unwrapInternalException(Throwable th) {
        while ((th instanceof WMRuntimeException || th instanceof WMException) && th.getCause() != null) {
            th = th.getCause();
        }
        return th;
    }

    public static Throwable getRootException(Throwable th) {
        while (th.getCause() != null) {
            th = th.getCause();
        }
        return th;
    }

    public static void addAllUnlessSet(Properties org, Properties p) {
        for (String s : CastUtils.cast(p.keySet())) {
            if (org.containsKey(s)) continue;
            org.setProperty(s, p.getProperty(s));
        }
    }

    public static void setPropertyUnlessSet(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    public static boolean allPropertiesAreSet(String ... propertyNames) {
        return SystemUtils.allPropertiesAreSet(System.getProperties(), propertyNames);
    }

    public static boolean allPropertiesAreSet(Properties properties, String ... propertyNames) {
        for (String s : propertyNames) {
            if (properties.getProperty(s) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromResource(String name) {
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            Properties properties = SystemUtils.loadPropertiesFromStream(is);
            return properties;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Properties loadPropertiesFromFile(String filepath) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filepath);
            Properties properties = SystemUtils.loadPropertiesFromStream(is);
            return properties;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception ignore) {}
        }
    }

    public static Properties loadPropertiesFromStream(InputStream inputStream) {
        try {
            Properties rtn = new Properties();
            rtn.load(inputStream);
            return rtn;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writePropertiesFile(OutputStream os, Properties props) {
        SystemUtils.writePropertiesFile(os, props, null, null);
    }

    public static void writePropertiesFile(OutputStream os, Properties props, String comment) {
        SystemUtils.writePropertiesFile(os, props, null, comment);
    }

    public static void writePropertiesFile(OutputStream os, Properties props, List<String> includePropertyNames, String comment) {
        try {
            if (includePropertyNames != null) {
                Properties p = new Properties();
                for (String key : CastUtils.cast(props.keySet())) {
                    if (!includePropertyNames.contains(key)) continue;
                    p.setProperty(key, props.getProperty(key));
                }
                props = p;
            }
            props.store(os, comment);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getLineBreak() {
        return org.apache.commons.lang.SystemUtils.LINE_SEPARATOR;
    }

    public static String getIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "127.0.0.1";
        }
    }

    private SystemUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").equalsIgnoreCase("linux");
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static String getWavemakerRoot() {
        String jdkPath = System.getProperty("java.home");
        String wmRoot = new File(jdkPath).getParentFile().getParentFile().getAbsolutePath();
        return wmRoot;
    }
}

