/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowawayFileClassLoader
extends ClassLoader {
    private final List<File> classPath;
    private final ClassLoader parentClassLoader;

    public ThrowawayFileClassLoader(List<File> classPath, ClassLoader parent) {
        super(null);
        this.classPath = classPath;
        this.parentClassLoader = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        String packageName;
        byte[] fileBytes;
        block13: {
            if (null == this.classPath) {
                throw new ClassNotFoundException("invalid search root: " + this.classPath);
            }
            if (null == name) {
                throw new ClassNotFoundException(Resource.NULL_CLASS.getMessage());
            }
            String classNamePath = name.replace('.', '/') + ".class";
            fileBytes = null;
            try {
                InputStream is = null;
                ZipFile jarFile = null;
                for (File entry : this.classPath) {
                    if (entry.getName().toLowerCase().endsWith(".jar")) {
                        jarFile = new JarFile(entry);
                        ZipEntry ze = ((JarFile)jarFile).getEntry(classNamePath);
                        if (null != ze) {
                            is = ((JarFile)jarFile).getInputStream(ze);
                            break;
                        }
                        jarFile.close();
                        continue;
                    }
                    File classFile = new File(entry, classNamePath);
                    if (!classFile.exists()) continue;
                    is = new FileInputStream(classFile);
                    break;
                }
                if (null == is) break block13;
                try {
                    fileBytes = IOUtils.toByteArray(is);
                    is.close();
                }
                finally {
                    if (null != jarFile) {
                        jarFile.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException(e.getMessage(), e);
            }
        }
        if (name.contains(".") && null == this.getPackage(packageName = name.substring(0, name.lastIndexOf(46)))) {
            this.definePackage(packageName, "", "", "", "", "", "", null);
        }
        if (null == (ret = null == fileBytes ? ClassLoaderUtils.loadClass(name, this.parentClassLoader) : this.defineClass(name, fileBytes, 0, fileBytes.length))) {
            throw new ClassNotFoundException("Couldn't find class " + name + " in expected classpath: " + this.classPath);
        }
        return ret;
    }

    @Override
    protected URL findResource(String name) {
        URL ret = null;
        JarFile jarFile = null;
        try {
            for (File entry : this.classPath) {
                if (entry.getName().toLowerCase().endsWith(".jar")) {
                    jarFile = new JarFile(entry);
                    ZipEntry ze = jarFile.getEntry(name);
                    jarFile.close();
                    if (null == ze) continue;
                    ret = new URL("jar:" + entry.toURI().toURL() + "!/" + name);
                } else {
                    File file = new File(entry, name);
                    if (!file.exists()) continue;
                    ret = file.toURI().toURL();
                }
                break;
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (null == url) {
            return null;
        }
        try {
            byte[] b;
            InputStream is = null;
            try {
                is = url.openStream();
                b = IOUtils.toByteArray(is);
            }
            finally {
                if (null != is) {
                    is.close();
                }
                url = null;
                is = null;
            }
            return new ByteArrayInputStream(b);
        }
        catch (IOException e) {
            return null;
        }
    }
}

