/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.util.ObjectLiteralParser;
import com.wavemaker.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConversionUtils {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap(8);
    private static final Collection<Class<?>> PRIMITIVE_WRAPPERS;

    private TypeConversionUtils() {
        throw new UnsupportedOperationException();
    }

    public static Class<?> primitiveForName(String className) {
        return PRIMITIVES.get(className);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.equals(String.class)) {
            return true;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        return PRIMITIVE_WRAPPERS.contains(clazz);
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz != null && (Collection.class.isAssignableFrom(clazz) || clazz.isArray());
    }

    public static boolean isMap(Class<?> clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    public static Object fromString(Class<?> type, String s) {
        return TypeConversionUtils.fromString(type, s, false);
    }

    public static Object fromString(Class<?> type, String s, boolean isList) {
        if (isList || !TypeConversionUtils.isPrimitiveOrWrapper(type)) {
            if (s == null) {
                return null;
            }
            ObjectLiteralParser p = new ObjectLiteralParser(s, type);
            Object o = p.parse();
            return o;
        }
        if (s == null) {
            return null;
        }
        if (type == AtomicInteger.class) {
            return null;
        }
        if (type == AtomicLong.class) {
            return null;
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(s);
        }
        if (type == BigInteger.class) {
            return new BigDecimal(s);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.valueOf(s);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.valueOf(s);
        }
        if (type == java.util.Date.class) {
            if (StringUtils.isNumber(s)) {
                return new java.util.Date(Long.valueOf(s));
            }
            throw new IllegalArgumentException("Unable to convert " + s + " to " + java.util.Date.class.getName());
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.valueOf(s);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(s);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(s);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.valueOf(s);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.valueOf(s);
        }
        if (type == String.class) {
            return s;
        }
        throw new AssertionError((Object)("Unable to convert \"" + s + "\" to " + type + " - unknown type: " + type));
    }

    public static String getValueString(Class<?> type, String s) {
        if (s == null) {
            return "null";
        }
        if (type == String.class || type == StringBuffer.class) {
            return "'" + s + "'";
        }
        if (type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == Time.class) {
            return "'" + s + "'";
        }
        return s;
    }

    public static boolean primitivesMatch(Class<?> p1, Class<?> p2) {
        if (!p1.isPrimitive() && !p2.isPrimitive()) {
            return false;
        }
        if (TypeConversionUtils.compare(p1, p2, Boolean.class, Boolean.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Byte.class, Byte.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Double.class, Double.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Float.class, Float.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Integer.class, Integer.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Long.class, Long.TYPE)) {
            return true;
        }
        return TypeConversionUtils.compare(p1, p2, Short.class, Short.TYPE);
    }

    private static boolean compare(Class<?> p1, Class<?> p2, Class<?> t1, Class<?> t2) {
        if (p1 == t1 && p2 == t2) {
            return true;
        }
        return p1 == t2 && p2 == t1;
    }

    static {
        PRIMITIVES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVE_WRAPPERS = new HashSet(11);
        PRIMITIVE_WRAPPERS.add(AtomicInteger.class);
        PRIMITIVE_WRAPPERS.add(AtomicLong.class);
        PRIMITIVE_WRAPPERS.add(BigDecimal.class);
        PRIMITIVE_WRAPPERS.add(BigInteger.class);
        PRIMITIVE_WRAPPERS.add(Boolean.class);
        PRIMITIVE_WRAPPERS.add(Byte.class);
        PRIMITIVE_WRAPPERS.add(Double.class);
        PRIMITIVE_WRAPPERS.add(Float.class);
        PRIMITIVE_WRAPPERS.add(Integer.class);
        PRIMITIVE_WRAPPERS.add(Long.class);
        PRIMITIVE_WRAPPERS.add(Short.class);
    }
}

