/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.deser;

import java.io.IOException;
import org.cloudfoundry.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.deser.StdDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.type.ArrayType;
import org.cloudfoundry.org.codehaus.jackson.map.util.ObjectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDeserializer
extends StdDeserializer<Object> {
    final Class<?> _arrayClass;
    final boolean _untyped;
    final Class<?> _elementClass;
    final JsonDeserializer<Object> _elementDeserializer;

    public ArrayDeserializer(ArrayType arrayType, JsonDeserializer<Object> elemDeser) {
        super(Object[].class);
        this._arrayClass = arrayType.getRawClass();
        this._elementClass = arrayType.getContentType().getRawClass();
        this._untyped = this._elementClass == Object.class;
        this._elementDeserializer = elemDeser;
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t;
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            if (jp.getCurrentToken() == JsonToken.VALUE_STRING && this._elementClass == Byte.class) {
                return this.deserializeFromBase64(jp, ctxt);
            }
            throw ctxt.mappingException(this._arrayClass);
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer.resetAndStart();
        int ix = 0;
        while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            Object value;
            Object object = value = t == JsonToken.VALUE_NULL ? null : this._elementDeserializer.deserialize(jp, ctxt);
            if (ix >= chunk.length) {
                chunk = buffer.appendCompletedChunk(chunk);
                ix = 0;
            }
            chunk[ix++] = value;
        }
        Object[] result = this._untyped ? buffer.completeAndClearBuffer(chunk, ix) : buffer.completeAndClearBuffer(chunk, ix, this._elementClass);
        ctxt.returnObjectBuffer(buffer);
        return result;
    }

    protected Byte[] deserializeFromBase64(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        byte[] b = jp.getBinaryValue(ctxt.getBase64Variant());
        Byte[] result = new Byte[b.length];
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            result[i] = b[i];
        }
        return result;
    }
}

