/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.deser;

import java.io.IOException;
import org.cloudfoundry.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializationConfig;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.org.codehaus.jackson.map.deser.StdDeserializer;
import org.cloudfoundry.org.codehaus.jackson.node.ArrayNode;
import org.cloudfoundry.org.codehaus.jackson.node.JsonNodeFactory;
import org.cloudfoundry.org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseNodeDeserializer<N extends JsonNode>
extends StdDeserializer<N> {
    protected JsonNodeFactory _nodeFactory = JsonNodeFactory.instance;

    public BaseNodeDeserializer(Class<N> nodeClass) {
        super(nodeClass);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public void setNodeFactory(JsonNodeFactory nf) {
        this._nodeFactory = nf;
    }

    protected void _reportProblem(JsonParser jp, String msg) throws JsonMappingException {
        throw new JsonMappingException(msg, jp.getTokenLocation());
    }

    protected void _handleDuplicateField(String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
    }

    protected final ObjectNode deserializeObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = this._nodeFactory.objectNode();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            JsonNode value = this.deserializeAny(jp, ctxt);
            JsonNode old = node.put(fieldName, value);
            if (old == null) continue;
            this._handleDuplicateField(fieldName, node, old, value);
        }
        return node;
    }

    protected final ArrayNode deserializeArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ArrayNode node = this._nodeFactory.arrayNode();
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            node.add(this.deserializeAny(jp, ctxt));
        }
        return node;
    }

    protected final JsonNode deserializeAny(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                return this.deserializeObject(jp, ctxt);
            }
            case START_ARRAY: {
                return this.deserializeArray(jp, ctxt);
            }
            case VALUE_STRING: {
                return this._nodeFactory.textNode(jp.getText());
            }
            case VALUE_NUMBER_INT: {
                JsonParser.NumberType nt = jp.getNumberType();
                if (nt == JsonParser.NumberType.BIG_INTEGER || ctxt.isEnabled(DeserializationConfig.Feature.USE_BIG_INTEGER_FOR_INTS)) {
                    return this._nodeFactory.numberNode(jp.getIntValue());
                }
                if (nt == JsonParser.NumberType.INT) {
                    return this._nodeFactory.numberNode(jp.getIntValue());
                }
                return this._nodeFactory.numberNode(jp.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                JsonParser.NumberType nt = jp.getNumberType();
                if (nt == JsonParser.NumberType.BIG_DECIMAL || ctxt.isEnabled(DeserializationConfig.Feature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return this._nodeFactory.numberNode(jp.getDecimalValue());
                }
                return this._nodeFactory.numberNode(jp.getDoubleValue());
            }
            case VALUE_TRUE: {
                return this._nodeFactory.booleanNode(true);
            }
            case VALUE_FALSE: {
                return this._nodeFactory.booleanNode(false);
            }
            case VALUE_NULL: {
                return this._nodeFactory.nullNode();
            }
        }
        throw ctxt.mappingException(this.getValueClass());
    }
}

