/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.ext;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.cloudfoundry.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.org.codehaus.jackson.map.deser.StdDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.util.Provider;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JodaDeserializers
implements Provider<StdDeserializer<?>> {
    @Override
    public Collection<StdDeserializer<?>> provide() {
        return Arrays.asList(new DateTimeDeserializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateTimeDeserializer
    extends StdDeserializer<DateTime> {
        public DateTimeDeserializer() {
            super(DateTime.class);
        }

        @Override
        public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return new DateTime(jp.getLongValue(), DateTimeZone.UTC);
            }
            if (t == JsonToken.VALUE_STRING) {
                return new DateTime((Object)jp.getText().trim(), DateTimeZone.UTC);
            }
            throw ctxt.mappingException(this.getValueClass());
        }
    }
}

