/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.ext;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerationException;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.org.codehaus.jackson.map.SerializationConfig;
import org.cloudfoundry.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.org.codehaus.jackson.map.ser.SerializerBase;
import org.cloudfoundry.org.codehaus.jackson.map.util.Provider;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JodaSerializers
implements Provider<Map.Entry<Class<?>, JsonSerializer<?>>> {
    static final HashMap<Class<?>, JsonSerializer<?>> _serializers = new HashMap();

    @Override
    public Collection<Map.Entry<Class<?>, JsonSerializer<?>>> provide() {
        return _serializers.entrySet();
    }

    static {
        _serializers.put(DateTime.class, new DateTimeSerializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DateTimeSerializer
    extends SerializerBase<DateTime> {
        @Override
        public void serialize(DateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (provider.isEnabled(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS)) {
                jgen.writeNumber(value.getMillis());
            } else {
                jgen.writeString(value.toString());
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode(provider.isEnabled(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS) ? "number" : "string", true);
        }
    }
}

