/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import org.cloudfoundry.org.codehaus.jackson.annotate.JacksonAnnotation;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonAnySetter;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonAutoDetect;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonClass;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonContentClass;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonCreator;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonGetter;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonIgnore;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonKeyClass;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonMethod;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonProperty;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonSetter;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonUseDeserializer;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonUseSerializer;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonValue;
import org.cloudfoundry.org.codehaus.jackson.annotate.JsonWriteNullProperties;
import org.cloudfoundry.org.codehaus.jackson.annotate.NoClass;
import org.cloudfoundry.org.codehaus.jackson.map.AnnotationIntrospector;
import org.cloudfoundry.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.org.codehaus.jackson.map.KeyDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.annotate.JsonCachable;
import org.cloudfoundry.org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.cloudfoundry.org.codehaus.jackson.map.annotate.JsonSerialize;
import org.cloudfoundry.org.codehaus.jackson.map.annotate.JsonView;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.Annotated;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedField;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonAnnotationIntrospector
extends AnnotationIntrospector {
    @Override
    public boolean isHandled(Annotation ann) {
        Class<? extends Annotation> acls = ann.annotationType();
        return acls.getAnnotation(JacksonAnnotation.class) != null;
    }

    @Override
    public String findNamespace(Annotated ann) {
        return null;
    }

    @Override
    public String findEnumValue(Enum<?> value) {
        return value.name();
    }

    @Override
    public Boolean findCachability(AnnotatedClass ac) {
        JsonCachable ann = ac.getAnnotation(JsonCachable.class);
        if (ann == null) {
            return null;
        }
        return ann.value() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean findFieldAutoDetection(AnnotatedClass ac) {
        JsonAutoDetect cann = ac.getAnnotation(JsonAutoDetect.class);
        if (cann != null) {
            JsonMethod[] methods = cann.value();
            if (methods != null) {
                for (JsonMethod jm : methods) {
                    if (!jm.fieldEnabled()) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String findRootName(AnnotatedClass ac) {
        return null;
    }

    @Override
    public String[] findPropertiesToIgnore(AnnotatedClass ac) {
        JsonIgnoreProperties ignore = ac.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : ignore.value();
    }

    @Override
    public Boolean findIgnoreUnknownProperties(AnnotatedClass ac) {
        JsonIgnoreProperties ignore = ac.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : Boolean.valueOf(ignore.ignoreUnknown());
    }

    @Override
    public boolean isIgnorableMethod(AnnotatedMethod m) {
        return this._isIgnorable(m);
    }

    @Override
    public boolean isIgnorableConstructor(AnnotatedConstructor c) {
        return this._isIgnorable(c);
    }

    @Override
    public boolean isIgnorableField(AnnotatedField f) {
        return this._isIgnorable(f);
    }

    @Override
    public Class<? extends JsonSerializer<?>> findSerializer(Annotated a) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.using()) != JsonSerializer.None.class) {
            return serClass;
        }
        JsonUseSerializer oldAnn = a.getAnnotation(JsonUseSerializer.class);
        if (oldAnn == null) {
            return null;
        }
        Class<?> serClass2 = oldAnn.value();
        if (serClass2 == NoClass.class || serClass2 == JsonSerializer.None.class) {
            return null;
        }
        if (!JsonSerializer.class.isAssignableFrom(serClass2)) {
            throw new IllegalArgumentException("Invalid @JsonUseSerializer annotation: Class " + serClass2.getName() + " not a JsonSerializer");
        }
        return serClass2;
    }

    @Override
    public JsonSerialize.Inclusion findSerializationInclusion(Annotated a, JsonSerialize.Inclusion defValue) {
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null) {
            return ann.include();
        }
        JsonWriteNullProperties oldAnn = a.getAnnotation(JsonWriteNullProperties.class);
        if (oldAnn != null) {
            boolean writeNulls = oldAnn.value();
            return writeNulls ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
        }
        return defValue;
    }

    @Override
    public Class<?> findSerializationType(Annotated am) {
        Class<?> cls;
        JsonSerialize ann = am.getAnnotation(JsonSerialize.class);
        if (ann != null && (cls = ann.as()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated a) {
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        return ann == null ? null : ann.typing();
    }

    @Override
    public Class<?>[] findSerializationViews(Annotated a) {
        JsonView ann = a.getAnnotation(JsonView.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public Boolean findGetterAutoDetection(AnnotatedClass ac) {
        JsonAutoDetect cann = ac.getAnnotation(JsonAutoDetect.class);
        if (cann != null) {
            JsonMethod[] methods = cann.value();
            if (methods != null) {
                for (JsonMethod jm : methods) {
                    if (!jm.getterEnabled()) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean findIsGetterAutoDetection(AnnotatedClass ac) {
        JsonAutoDetect cann = ac.getAnnotation(JsonAutoDetect.class);
        if (cann != null) {
            JsonMethod[] methods = cann.value();
            if (methods != null) {
                for (JsonMethod jm : methods) {
                    if (!jm.isGetterEnabled()) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
        JsonPropertyOrder order = ac.getAnnotation(JsonPropertyOrder.class);
        return order == null ? null : order.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(AnnotatedClass ac) {
        JsonPropertyOrder order = ac.getAnnotation(JsonPropertyOrder.class);
        return order == null ? null : Boolean.valueOf(order.alphabetic());
    }

    @Override
    public String findGettablePropertyName(AnnotatedMethod am) {
        JsonProperty pann = am.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        JsonGetter ann = am.getAnnotation(JsonGetter.class);
        if (ann != null) {
            return ann.value();
        }
        if (am.hasAnnotation(JsonSerialize.class)) {
            return "";
        }
        return null;
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod am) {
        JsonValue ann = am.getAnnotation(JsonValue.class);
        return ann != null && ann.value();
    }

    @Override
    public String findSerializablePropertyName(AnnotatedField af) {
        JsonProperty pann = af.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        if (af.hasAnnotation(JsonSerialize.class)) {
            return "";
        }
        return null;
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findDeserializer(Annotated a) {
        Class<? extends JsonDeserializer<?>> deserClass;
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.using()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        JsonUseDeserializer oldAnn = a.getAnnotation(JsonUseDeserializer.class);
        if (oldAnn == null) {
            return null;
        }
        Class<?> deserClass2 = oldAnn.value();
        if (deserClass2 == NoClass.class || deserClass2 == JsonDeserializer.None.class) {
            return null;
        }
        if (!JsonDeserializer.class.isAssignableFrom(deserClass2)) {
            throw new IllegalArgumentException("Invalid @JsonUseDeserializer annotation: Class " + deserClass2.getName() + " not a JsonDeserializer");
        }
        return deserClass2;
    }

    @Override
    public Class<? extends KeyDeserializer> findKeyDeserializer(Annotated a) {
        Class<? extends KeyDeserializer> deserClass;
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.keyUsing()) != KeyDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findContentDeserializer(Annotated a) {
        Class<? extends JsonDeserializer<?>> deserClass;
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.contentUsing()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationType(Annotated am) {
        Class<?> cls;
        Class<?> cls2;
        JsonDeserialize ann = am.getAnnotation(JsonDeserialize.class);
        if (ann != null && (cls2 = ann.as()) != NoClass.class) {
            return cls2;
        }
        JsonClass oldAnn = am.getAnnotation(JsonClass.class);
        if (oldAnn != null && (cls = oldAnn.value()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationKeyType(Annotated am) {
        Class<?> cls;
        Class<?> cls2;
        JsonDeserialize ann = am.getAnnotation(JsonDeserialize.class);
        if (ann != null && (cls2 = ann.keyAs()) != NoClass.class) {
            return cls2;
        }
        JsonKeyClass oldAnn = am.getAnnotation(JsonKeyClass.class);
        if (oldAnn != null && (cls = oldAnn.value()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationContentType(Annotated am) {
        Class<?> cls;
        Class<?> cls2;
        JsonDeserialize ann = am.getAnnotation(JsonDeserialize.class);
        if (ann != null && (cls2 = ann.contentAs()) != NoClass.class) {
            return cls2;
        }
        JsonContentClass oldAnn = am.getAnnotation(JsonContentClass.class);
        if (oldAnn != null && (cls = oldAnn.value()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Boolean findCreatorAutoDetection(AnnotatedClass ac) {
        JsonAutoDetect cann = ac.getAnnotation(JsonAutoDetect.class);
        if (cann != null) {
            JsonMethod[] methods = cann.value();
            if (methods != null) {
                for (JsonMethod jm : methods) {
                    if (!jm.creatorEnabled()) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean findSetterAutoDetection(AnnotatedClass ac) {
        JsonAutoDetect cann = ac.getAnnotation(JsonAutoDetect.class);
        if (cann != null) {
            JsonMethod[] methods = cann.value();
            if (methods != null) {
                for (JsonMethod jm : methods) {
                    if (!jm.setterEnabled()) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String findSettablePropertyName(AnnotatedMethod am) {
        JsonProperty pann = am.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        JsonSetter ann = am.getAnnotation(JsonSetter.class);
        if (ann != null) {
            return ann.value();
        }
        if (am.hasAnnotation(JsonDeserialize.class)) {
            return "";
        }
        return null;
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
        return am.hasAnnotation(JsonAnySetter.class);
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated a) {
        return a.hasAnnotation(JsonCreator.class);
    }

    @Override
    public String findDeserializablePropertyName(AnnotatedField af) {
        JsonProperty pann = af.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        if (af.hasAnnotation(JsonDeserialize.class)) {
            return "";
        }
        return null;
    }

    @Override
    public String findPropertyNameForParam(AnnotatedParameter param) {
        JsonProperty pann;
        if (param != null && (pann = param.getAnnotation(JsonProperty.class)) != null) {
            return pann.value();
        }
        return null;
    }

    protected boolean _isIgnorable(Annotated a) {
        JsonIgnore ann = a.getAnnotation(JsonIgnore.class);
        return ann != null && ann.value();
    }
}

