/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerationException;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.org.codehaus.jackson.map.AnnotationIntrospector;
import org.cloudfoundry.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.org.codehaus.jackson.map.ser.SerializerBase;
import org.cloudfoundry.org.codehaus.jackson.map.type.TypeFactory;
import org.cloudfoundry.org.codehaus.jackson.map.util.EnumValues;
import org.cloudfoundry.org.codehaus.jackson.node.ArrayNode;
import org.cloudfoundry.org.codehaus.jackson.node.ObjectNode;
import org.cloudfoundry.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSerializer
extends SerializerBase<Enum<?>> {
    protected final EnumValues _values;

    public EnumSerializer(EnumValues v) {
        this._values = v;
    }

    public static EnumSerializer construct(Class<Enum<?>> enumClass, AnnotationIntrospector intr) {
        return new EnumSerializer(EnumValues.construct(enumClass, intr));
    }

    @Override
    public void serialize(Enum<?> en, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeString(this._values.valueFor(en));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        JavaType type;
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (typeHint != null && (type = TypeFactory.type(typeHint)).isEnumType()) {
            ArrayNode enumNode = objectNode.putArray("enum");
            for (String value : this._values.values()) {
                enumNode.add(value);
            }
        }
        return objectNode;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }
}

