/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.ser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerationException;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.org.codehaus.jackson.map.ser.SerializerBase;
import org.cloudfoundry.org.codehaus.jackson.map.ser.ToStringSerializer;
import org.cloudfoundry.org.codehaus.jackson.map.util.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkSerializers
implements Provider<Map.Entry<Class<?>, JsonSerializer<?>>> {
    @Override
    public Collection<Map.Entry<Class<?>, JsonSerializer<?>>> provide() {
        HashMap<Class, SerializerBase> sers = new HashMap<Class, SerializerBase>();
        sers.put(File.class, new FileSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        sers.put(URL.class, sls);
        sers.put(URI.class, sls);
        sers.put(Currency.class, sls);
        sers.put(UUID.class, sls);
        sers.put(Pattern.class, sls);
        return sers.entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileSerializer
    extends SerializerBase<File> {
        @Override
        public void serialize(File value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.getAbsolutePath());
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("string", true);
        }
    }
}

