/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerationException;
import org.cloudfoundry.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.org.codehaus.jackson.map.ser.SerializerBase;
import org.cloudfoundry.org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer
extends SerializerBase<Map<?, ?>> {
    public static final MapSerializer instance = new MapSerializer();
    protected final HashSet<String> _ignoredEntries;

    protected MapSerializer() {
        this(null);
    }

    protected MapSerializer(String[] ignoredEntries) {
        if (ignoredEntries == null || ignoredEntries.length == 0) {
            this._ignoredEntries = null;
        } else {
            this._ignoredEntries = new HashSet(ignoredEntries.length);
            for (String prop : ignoredEntries) {
                this._ignoredEntries.add(prop);
            }
        }
    }

    public static MapSerializer construct(String[] ignoredEntries) {
        if (ignoredEntries == null || ignoredEntries.length == 0) {
            return instance;
        }
        return new MapSerializer(ignoredEntries);
    }

    @Override
    public void serialize(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        if (!value.isEmpty()) {
            if (this._ignoredEntries == null) {
                this.serializeEntries(value, jgen, provider);
            } else {
                this.serializeSomeEntries(value, jgen, provider, this._ignoredEntries);
            }
        }
        jgen.writeEndObject();
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("object", true);
        return o;
    }

    protected final void serializeEntries(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        JsonSerializer<Object> keySerializer = provider.getKeySerializer();
        JsonSerializer<Object> prevValueSerializer = null;
        Class<?> prevValueClass = null;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> currSerializer;
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.getNullKeySerializer().serialize(null, jgen, provider);
            } else {
                keySerializer.serialize(keyElem, jgen, provider);
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                provider.getNullValueSerializer().serialize(null, jgen, provider);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            if (cc == prevValueClass) {
                currSerializer = prevValueSerializer;
            } else {
                prevValueSerializer = currSerializer = provider.findValueSerializer(cc);
                prevValueClass = cc;
            }
            try {
                currSerializer.serialize(valueElem, jgen, provider);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow((Throwable)e, value, keyDesc);
            }
        }
    }

    protected final void serializeSomeEntries(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider, HashSet<String> ignored) throws IOException, JsonGenerationException {
        JsonSerializer<Object> keySerializer = provider.getKeySerializer();
        JsonSerializer<Object> prevValueSerializer = null;
        Class<?> prevValueClass = null;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> currSerializer;
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.getNullKeySerializer().serialize(null, jgen, provider);
            } else {
                if (ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, jgen, provider);
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                provider.getNullValueSerializer().serialize(null, jgen, provider);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            if (cc == prevValueClass) {
                currSerializer = prevValueSerializer;
            } else {
                prevValueSerializer = currSerializer = provider.findValueSerializer(cc);
                prevValueClass = cc;
            }
            try {
                currSerializer.serialize(valueElem, jgen, provider);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow((Throwable)e, value, keyDesc);
            }
        }
    }
}

