/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.ser;

import java.util.HashMap;
import org.cloudfoundry.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.org.codehaus.jackson.map.ser.ReadOnlyClassToSerializerMap;
import org.cloudfoundry.org.codehaus.jackson.map.type.ClassKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializerCache {
    private HashMap<ClassKey, JsonSerializer<Object>> _sharedMap = new HashMap(64);
    private ReadOnlyClassToSerializerMap _readOnlyMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._readOnlyMap == null) {
                this._readOnlyMap = ReadOnlyClassToSerializerMap.from(this._sharedMap);
            }
            return this._readOnlyMap.instance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> findSerializer(Class<?> type) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new ClassKey(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSerializer(Class<?> type, JsonSerializer<Object> ser) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            ClassKey key = new ClassKey(type);
            if (this._sharedMap.put(key, ser) == null) {
                this._readOnlyMap = null;
            }
        }
    }

    public synchronized int size() {
        return this._sharedMap.size();
    }

    public synchronized void flush() {
        this._sharedMap.clear();
    }
}

