/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.type;

import org.cloudfoundry.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapType
extends JavaType {
    final JavaType _keyType;
    final JavaType _valueType;

    private MapType(Class<?> mapType, JavaType keyT, JavaType valueT) {
        super(mapType);
        this._keyType = keyT;
        this._hashCode += keyT.hashCode();
        this._valueType = valueT;
        this._hashCode += valueT.hashCode();
    }

    public static MapType construct(Class<?> rawType, JavaType keyT, JavaType valueT) {
        return new MapType(rawType, keyT, valueT);
    }

    @Override
    protected JavaType _narrow(Class<?> subclass) {
        return new MapType(subclass, this._keyType, this._valueType);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> contentClass) {
        if (contentClass == this._valueType.getRawClass()) {
            return this;
        }
        JavaType newValueType = this._valueType.narrowBy(contentClass);
        return new MapType(this._class, this._keyType, newValueType);
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    public JavaType narrowKey(Class<?> keySubclass) {
        if (keySubclass == this._keyType.getRawClass()) {
            return this;
        }
        JavaType newKeyType = this._keyType.narrowBy(keySubclass);
        return new MapType(this._class, newKeyType, this._valueType);
    }

    @Override
    public JavaType getKeyType() {
        return this._keyType;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public String toString() {
        return "[map type; class " + this._class.getName() + ", " + this._keyType + " -> " + this._valueType + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        MapType other = (MapType)o;
        return this._class == other._class && this._keyType.equals(other._keyType) && this._valueType.equals(other._valueType);
    }
}

