/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.org.codehaus.jackson.map.type.ArrayType;
import org.cloudfoundry.org.codehaus.jackson.map.type.CollectionType;
import org.cloudfoundry.org.codehaus.jackson.map.type.MapType;
import org.cloudfoundry.org.codehaus.jackson.map.type.SimpleType;
import org.cloudfoundry.org.codehaus.jackson.type.JavaType;
import org.cloudfoundry.org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactory {
    public static final TypeFactory instance = new TypeFactory();

    private TypeFactory() {
    }

    public static JavaType type(Type t) {
        return instance._fromType(t, null);
    }

    public static JavaType type(Type type, JavaType context) {
        return instance._fromType(type, context);
    }

    public static JavaType type(TypeReference<?> ref) {
        return TypeFactory.type(ref.getType());
    }

    public static JavaType arrayType(Class<?> elementType) {
        return TypeFactory.arrayType(TypeFactory.type(elementType));
    }

    public static JavaType arrayType(JavaType elementType) {
        return ArrayType.construct(elementType);
    }

    public static JavaType collectionType(Class<? extends Collection> collectionType, Class<?> elementType) {
        return TypeFactory.collectionType(collectionType, TypeFactory.type(elementType));
    }

    public static JavaType collectionType(Class<? extends Collection> collectionType, JavaType elementType) {
        return CollectionType.construct(collectionType, elementType);
    }

    public static JavaType mapType(Class<? extends Map> mapType, Class<?> keyType, Class<?> valueType) {
        return TypeFactory.mapType(mapType, TypeFactory.type(keyType), TypeFactory.type(valueType));
    }

    public static JavaType mapType(Class<? extends Map> mapType, JavaType keyType, JavaType valueType) {
        return MapType.construct(mapType, keyType, valueType);
    }

    public static JavaType fromClass(Class<?> clz) {
        return instance._fromClass(clz, null);
    }

    public static JavaType fromTypeReference(TypeReference<?> ref) {
        return TypeFactory.type(ref.getType());
    }

    public static JavaType fromType(Type type) {
        return instance._fromType(type, null);
    }

    public static JavaType fromType(Type type, JavaType context) {
        return instance._fromType(type, context);
    }

    protected JavaType _fromClass(Class<?> clz, Map<String, JavaType> genericParams) {
        if (clz.isArray()) {
            return ArrayType.construct(this._fromType(clz.getComponentType(), null));
        }
        if (Map.class.isAssignableFrom(clz)) {
            MapType parentType = this._findParentType(clz, MapType.class);
            if (parentType == null) {
                JavaType unknown = this._unknownType();
                return MapType.construct(clz, unknown, unknown);
            }
            return MapType.construct(clz, parentType.getKeyType(), parentType.getContentType());
        }
        if (Collection.class.isAssignableFrom(clz)) {
            CollectionType parentType = this._findParentType(clz, CollectionType.class);
            return CollectionType.construct(clz, parentType == null ? this._unknownType() : parentType.getContentType());
        }
        return new SimpleType(clz, genericParams);
    }

    public JavaType _fromType(Type type, JavaType context) {
        if (type instanceof Class) {
            return this._fromClass((Class)type, null);
        }
        if (type instanceof ParameterizedType) {
            return this._fromParamType((ParameterizedType)type, context);
        }
        if (type instanceof GenericArrayType) {
            return this._fromArrayType((GenericArrayType)type, context);
        }
        if (type instanceof TypeVariable) {
            return this._fromVariable((TypeVariable)type, context);
        }
        if (type instanceof WildcardType) {
            return this._fromWildcard((WildcardType)type, context);
        }
        throw new IllegalArgumentException("Unrecognized Type: " + type.toString());
    }

    protected JavaType _fromParamType(ParameterizedType type, JavaType context) {
        Class rawType = (Class)type.getRawType();
        if (Map.class.isAssignableFrom(rawType)) {
            Type[] args = type.getActualTypeArguments();
            JavaType keyType = this._fromType(args[0], context);
            JavaType valueType = this._fromType(args[1], context);
            return MapType.construct(rawType, keyType, valueType);
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            Type[] args = type.getActualTypeArguments();
            JavaType valueType = this._fromType(args[0], context);
            return CollectionType.construct(rawType, valueType);
        }
        Type[] args = type.getActualTypeArguments();
        HashMap<String, JavaType> types = null;
        if (args != null && args.length > 0) {
            TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
            if (vars.length != args.length) {
                throw new IllegalArgumentException("Strange parametrized type (raw: " + rawType + "): number of type arguments != number of type parameters (" + args.length + " vs " + vars.length + ")");
            }
            types = new HashMap<String, JavaType>();
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                TypeVariable var = vars[i];
                JavaType varType = this._fromType(args[i], context);
                types.put(var.getName(), varType);
            }
        }
        return this._fromClass(rawType, types);
    }

    protected JavaType _fromArrayType(GenericArrayType type, JavaType context) {
        JavaType compType = this._fromType(type.getGenericComponentType(), context);
        return ArrayType.construct(compType);
    }

    protected JavaType _fromVariable(TypeVariable<?> type, JavaType context) {
        if (context == null) {
            return this._unknownType();
        }
        String name = type.getName();
        JavaType actualType = context.findVariableType(name);
        if (actualType != null) {
            return actualType;
        }
        throw new IllegalArgumentException("Unresolved TypeVariable <" + name + "> (from " + type.getGenericDeclaration() + ")");
    }

    protected JavaType _fromWildcard(WildcardType type, JavaType context) {
        return this._fromType(type.getUpperBounds()[0], context);
    }

    protected <T extends JavaType> T _findParentType(Class<?> clz, Class<T> expType) {
        JavaType parent;
        Type parentType = clz.getGenericSuperclass();
        if (parentType != null && expType.isAssignableFrom((parent = this._fromType(parentType, null)).getClass())) {
            return (T)parent;
        }
        return null;
    }

    protected JavaType _unknownType() {
        return this._fromClass(Object.class, null);
    }
}

