/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import java.util.List;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public abstract class AbstractCloudServiceFactory<S, SI extends AbstractServiceInfo>
extends AbstractFactoryBean<S> {
    private Class<SI> serviceInfoClass;
    protected String serviceName;
    private CloudEnvironment cloudEnvironment;

    public AbstractCloudServiceFactory(Class<SI> serviceInfoClass, CloudEnvironment cloudEnvironment) {
        this.serviceInfoClass = serviceInfoClass;
        this.cloudEnvironment = cloudEnvironment;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    protected S createInstance() throws Exception {
        if (this.serviceName != null) {
            SI serviceInfo = this.cloudEnvironment.getServiceInfo(this.serviceName, this.serviceInfoClass);
            if (serviceInfo == null) {
                return null;
            }
            return this.getServiceCreator().createSingletonService(serviceInfo).service;
        }
        List<SI> serviceInfos = this.cloudEnvironment.getServiceInfos(this.serviceInfoClass);
        if (serviceInfos.size() != 1) {
            throw new CloudServiceException("Expected 1 service of " + this.serviceInfoClass + " type, but found" + serviceInfos.size());
        }
        return this.getServiceCreator().createSingletonService((AbstractServiceInfo)serviceInfos.get((int)0)).service;
    }

    public List<AbstractServiceCreator.ServiceNameTuple<S>> createInstances() {
        return this.getServiceCreator().createServices(this.cloudEnvironment.getServiceInfos(this.serviceInfoClass));
    }

    protected abstract AbstractServiceCreator<S, SI> getServiceCreator();
}

