/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.springframework.beans.BeanWrapper;

public abstract class AbstractServiceCreator<S, SI extends AbstractServiceInfo> {
    public abstract S createService(SI var1);

    public ServiceNameTuple<S> createSingletonService(SI singletonServiceInfo) {
        return new ServiceNameTuple<S>(this.createService(singletonServiceInfo), ((AbstractServiceInfo)singletonServiceInfo).getServiceName());
    }

    public List<ServiceNameTuple<S>> createServices(List<SI> serviceInfos) {
        ArrayList<ServiceNameTuple<S>> services = new ArrayList<ServiceNameTuple<S>>();
        for (AbstractServiceInfo serviceInfo : serviceInfos) {
            services.add(new ServiceNameTuple<S>(this.createService(serviceInfo), serviceInfo.getServiceName()));
        }
        return services;
    }

    protected void setCorrespondingProperties(BeanWrapper target, BeanWrapper source) {
        for (PropertyDescriptor pd : source.getPropertyDescriptors()) {
            String property = pd.getName();
            if ("class".equals(property) || !source.isReadableProperty(property) || source.getPropertyValue(property) == null || !target.isWritableProperty(property)) continue;
            target.setPropertyValue(property, source.getPropertyValue(property));
        }
    }

    protected boolean hasClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static class ServiceNameTuple<S> {
        public S service;
        public String name;

        public ServiceNameTuple(S service, String name) {
            this.service = service;
            this.name = name;
        }
    }
}

