/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import org.springframework.util.StringUtils;

public class CloudPoolConfiguration {
    private Integer minPoolSize;
    private Integer maxPoolSize;
    private Integer maxWaitTime;

    public Integer getInitialSize() {
        return this.minPoolSize;
    }

    public Integer getMinIdle() {
        return this.minPoolSize;
    }

    public Integer getMaxActive() {
        return this.maxPoolSize;
    }

    public Integer getMaxWait() {
        return this.maxWaitTime;
    }

    public void setPoolSize(String poolSize) {
        this.determinePoolSizeRange(poolSize);
    }

    public void setMaxWaitTime(Integer maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    private void determinePoolSizeRange(String poolSize) {
        if (StringUtils.hasText((String)poolSize)) {
            try {
                int maxPoolSize;
                int minPoolSize;
                int separatorIndex = poolSize.indexOf(45);
                if (separatorIndex != -1) {
                    minPoolSize = Integer.valueOf(poolSize.substring(0, separatorIndex));
                    if (minPoolSize > (maxPoolSize = Integer.valueOf(poolSize.substring(separatorIndex + 1, poolSize.length())).intValue())) {
                        throw new IllegalArgumentException("Lower bound of pool-size range must not exceed the upper bound");
                    }
                } else {
                    Integer value = Integer.valueOf(poolSize);
                    minPoolSize = 0;
                    maxPoolSize = value;
                }
                this.minPoolSize = minPoolSize;
                this.maxPoolSize = maxPoolSize;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid pool-size value [" + poolSize + "]: only single " + "maximum integer (e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported", ex);
            }
        }
    }
}

