/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import java.util.List;
import java.util.logging.Logger;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.env.MongoServiceInfo;
import org.cloudfoundry.runtime.env.RabbitServiceInfo;
import org.cloudfoundry.runtime.env.RdbmsServiceInfo;
import org.cloudfoundry.runtime.env.RedisServiceInfo;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.cloudfoundry.runtime.service.document.MongoServiceCreator;
import org.cloudfoundry.runtime.service.keyvalue.RedisServiceCreator;
import org.cloudfoundry.runtime.service.messaging.RabbitServiceCreator;
import org.cloudfoundry.runtime.service.relational.RdbmsServiceCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class CloudServicesScanner
implements BeanFactoryPostProcessor {
    Logger logger = Logger.getLogger(CloudServicesScanner.class.getName());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        CloudEnvironment cloudEnvironment;
        String[] envBeans = beanFactory.getBeanNamesForType(CloudEnvironment.class);
        if (envBeans.length == 0) {
            cloudEnvironment = new CloudEnvironment();
            beanFactory.registerSingleton("cloud-environment", (Object)cloudEnvironment);
        } else if (envBeans.length == 1) {
            cloudEnvironment = (CloudEnvironment)beanFactory.getBean(CloudEnvironment.class);
        } else {
            throw new CloudServiceException("CloudServicesScanner expects 0 or 1 bean of CloudEnvironment, found " + envBeans.length);
        }
        this.createCloudServiceBeans(beanFactory, cloudEnvironment);
    }

    protected void createCloudServiceBeans(ConfigurableListableBeanFactory beanFactory, CloudEnvironment cloudEnvironment) {
        this.logger.info("Auto-creating service beans");
        if (this.hasServicesOfType(cloudEnvironment, MongoServiceInfo.class)) {
            this.registerServiceBeans(beanFactory, cloudEnvironment, new MongoServiceCreator(), MongoServiceInfo.class);
        }
        if (this.hasServicesOfType(cloudEnvironment, RedisServiceInfo.class)) {
            this.registerServiceBeans(beanFactory, cloudEnvironment, new RedisServiceCreator(), RedisServiceInfo.class);
        }
        if (this.hasServicesOfType(cloudEnvironment, RabbitServiceInfo.class)) {
            this.registerServiceBeans(beanFactory, cloudEnvironment, new RabbitServiceCreator(), RabbitServiceInfo.class);
        }
        if (this.hasServicesOfType(cloudEnvironment, RdbmsServiceInfo.class)) {
            this.registerServiceBeans(beanFactory, cloudEnvironment, new RdbmsServiceCreator(), RdbmsServiceInfo.class);
        }
    }

    protected boolean hasServicesOfType(CloudEnvironment cloudEnvironment, Class<? extends AbstractServiceInfo> serviceInfoClass) {
        return !cloudEnvironment.getServiceInfos(serviceInfoClass).isEmpty();
    }

    protected <S, T extends AbstractServiceInfo> void registerServiceBeans(ConfigurableListableBeanFactory beanFactory, CloudEnvironment cloudEnvironment, AbstractServiceCreator<S, T> serviceCreator, Class<T> serviceInfoType) {
        List<AbstractServiceCreator.ServiceNameTuple<S>> serviceNamePairs = serviceCreator.createServices(cloudEnvironment.getServiceInfos(serviceInfoType));
        for (AbstractServiceCreator.ServiceNameTuple<S> serviceNamePair : serviceNamePairs) {
            this.logger.info("Auto-creating service bean for " + serviceNamePair.name);
            beanFactory.registerSingleton(serviceNamePair.name, serviceNamePair.service);
        }
    }
}

