/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service.config.xml;

import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.service.config.xml.AbstractNestedElementCloudServiceFactoryParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CloudMongoDbFactoryParser
extends AbstractNestedElementCloudServiceFactoryParser {
    private static final String ELEMENT_MONGO_OPTIONS = "mongo-options";

    public CloudMongoDbFactoryParser(Class<?> beanClass, Class<? extends AbstractServiceInfo> serviceInfoClass) {
        super(beanClass, serviceInfoClass);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        BeanDefinitionBuilder cloudMongoConfigurationBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.cloudfoundry.runtime.service.document.CloudMongoConfiguration");
        this.parseWriteConcern(element, cloudMongoConfigurationBeanBuilder);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!this.isElement(child, parserContext, ELEMENT_MONGO_OPTIONS)) continue;
            this.parseMongoOptionsElement((Element)child, cloudMongoConfigurationBeanBuilder);
        }
        builder.addPropertyValue("cloudMongoConfiguration", (Object)cloudMongoConfigurationBeanBuilder.getBeanDefinition());
    }

    private void parseWriteConcern(Element element, BeanDefinitionBuilder cloudMongoConfigurationBeanBuilder) {
        String writeConcern = element.getAttribute("write-concern");
        if (StringUtils.hasText((String)writeConcern)) {
            cloudMongoConfigurationBeanBuilder.addPropertyValue("writeConcern", (Object)writeConcern);
        }
    }

    private void parseMongoOptionsElement(Element element, BeanDefinitionBuilder cloudMongoConfigurationBeanBuilder) {
        String maxWaitTime;
        String connectionsPerHost = element.getAttribute("connections-per-host");
        if (StringUtils.hasText((String)connectionsPerHost)) {
            cloudMongoConfigurationBeanBuilder.addPropertyValue("connectionsPerHost", (Object)connectionsPerHost);
        }
        if (StringUtils.hasText((String)(maxWaitTime = element.getAttribute("max-wait-time")))) {
            cloudMongoConfigurationBeanBuilder.addPropertyValue("maxWaitTime", (Object)maxWaitTime);
        }
    }
}

