/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service.messaging;

import org.cloudfoundry.runtime.env.RabbitServiceInfo;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.cloudfoundry.runtime.service.messaging.CloudRabbitConfiguration;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;

public class RabbitServiceCreator
extends AbstractServiceCreator<ConnectionFactory, RabbitServiceInfo> {
    private CloudRabbitConfiguration cloudRabbitConfiguration;

    public void setCloudRabbitConfiguration(CloudRabbitConfiguration cloudRabbitConfiguration) {
        this.cloudRabbitConfiguration = cloudRabbitConfiguration;
    }

    @Override
    public ConnectionFactory createService(RabbitServiceInfo serviceInfo) {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(serviceInfo.getHost());
        connectionFactory.setVirtualHost(serviceInfo.getVirtualHost());
        connectionFactory.setUsername(serviceInfo.getUserName());
        connectionFactory.setPassword(serviceInfo.getPassword());
        connectionFactory.setPort(serviceInfo.getPort());
        if (this.cloudRabbitConfiguration != null) {
            connectionFactory.setChannelCacheSize(this.cloudRabbitConfiguration.getChannelCacheSize().intValue());
        }
        return connectionFactory;
    }
}

